/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.skiing.core.data.gen;

import com.affehund.skiing.common.entity.SkisEntity;
import com.affehund.skiing.common.item.PulloverItem;
import com.affehund.skiing.common.item.SkisItem;
import com.affehund.skiing.core.data.gen.AlwaysExistingModelFile;
import com.affehund.skiing.core.data.gen.ModTags;
import com.affehund.skiing.core.init.ModEntities;
import com.affehund.skiing.core.init.ModItemGroup;
import com.affehund.skiing.core.init.ModItems;
import com.affehund.skiing.core.init.ModVillagers;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ItemTagsProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModDataGeneration {
    private static final Logger DATAGEN_LOGGER = LogManager.getLogger();

    public static final class ItemTagsGen
    extends ItemTagsProvider {
        public ItemTagsGen(DataGenerator gen, BlockTagsProvider provider, String modID, ExistingFileHelper existingFileHelper) {
            super(gen, provider, modID, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_(ModTags.Items.WOOL).func_240534_a_((Object[])new Item[]{Items.field_221618_aT}).func_240534_a_((Object[])new Item[]{Items.field_221614_aP}).func_240534_a_((Object[])new Item[]{Items.field_221615_aQ}).func_240534_a_((Object[])new Item[]{Items.field_221612_aN}).func_240534_a_((Object[])new Item[]{Items.field_221610_aL}).func_240534_a_((Object[])new Item[]{Items.field_221616_aR}).func_240534_a_((Object[])new Item[]{Items.field_221606_aH}).func_240534_a_((Object[])new Item[]{Items.field_221611_aM}).func_240534_a_((Object[])new Item[]{Items.field_221608_aJ}).func_240534_a_((Object[])new Item[]{Items.field_221605_aG}).func_240534_a_((Object[])new Item[]{Items.field_221604_aF}).func_240534_a_((Object[])new Item[]{Items.field_221609_aK}).func_240534_a_((Object[])new Item[]{Items.field_221613_aO}).func_240534_a_((Object[])new Item[]{Items.field_221617_aS}).func_240534_a_((Object[])new Item[]{Items.field_221603_aE}).func_240534_a_((Object[])new Item[]{Items.field_221607_aI});
            this.func_240522_a_(ModTags.Items.PLANKS).func_240534_a_((Object[])new Item[]{Items.field_221590_r}).func_240534_a_((Object[])new Item[]{Items.field_221588_p}).func_240534_a_((Object[])new Item[]{Items.field_234798_v_}).func_240534_a_((Object[])new Item[]{Items.field_221591_s}).func_240534_a_((Object[])new Item[]{Items.field_221589_q}).func_240534_a_((Object[])new Item[]{Items.field_221586_n}).func_240534_a_((Object[])new Item[]{Items.field_221587_o}).func_240534_a_((Object[])new Item[]{Items.field_234799_w_});
        }
    }

    public static final class BlockTagsGen
    extends BlockTagsProvider {
        public BlockTagsGen(DataGenerator gen, String modID, ExistingFileHelper existingFileHelper) {
            super(gen, modID, existingFileHelper);
        }

        protected void func_200432_c() {
            this.func_240522_a_(ModTags.Blocks.SNOWY_BLOCKS).func_240534_a_((Object[])new Block[]{Blocks.field_205164_gk, Blocks.field_185778_de, Blocks.field_150432_aD, Blocks.field_150403_cj, Blocks.field_150433_aE, Blocks.field_196604_cC});
        }
    }

    public static final class RecipeGen
    extends RecipeProvider
    implements IConditionBuilder {
        public RecipeGen(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221590_r, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.ACACIA);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221588_p, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.BIRCH);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_234798_v_, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.CRIMSON);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221591_s, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.DARK_OAK);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221589_q, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.JUNGLE);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221586_n, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.OAK);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_221587_o, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.SPRUCE);
            this.addSkisRecipe(consumer, (IItemProvider)Items.field_234799_w_, (IItemProvider)ModItems.SKIS_ITEM.get(), SkisEntity.SkisType.WARPED);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221618_aT, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.BLACK);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221614_aP, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.BLUE);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221615_aQ, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.BROWN);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221612_aN, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.CYAN);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221610_aL, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.GRAY);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221616_aR, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.GREEN);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221606_aH, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.LIGHT_BLUE);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221611_aM, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.LIGHT_GRAY);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221608_aJ, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.LIME);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221605_aG, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.MAGENTA);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221604_aF, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.ORANGE);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221609_aK, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.PINK);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221613_aO, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.PURPLE);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221617_aS, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.RED);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221603_aE, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.WHITE);
            this.addPulloverRecipe(consumer, (IItemProvider)Items.field_221607_aI, (IItemProvider)ModItems.PULLOVER.get(), DyeColor.YELLOW);
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)ModItems.CHOCOLATE_CUP.get())).func_200487_b((IItemProvider)Items.field_151117_aB).func_200487_b((IItemProvider)Items.field_151133_ar).func_200487_b((IItemProvider)Items.field_196130_bo).func_200487_b((IItemProvider)Items.field_196130_bo).func_200483_a("has_item", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_196130_bo)).func_200483_a("has_item2", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151117_aB)).func_200483_a("has_item3", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151133_ar)).func_200482_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ModItems.SNOW_SHOVEL.get())).func_200472_a(" b ").func_200472_a(" s ").func_200472_a(" s ").func_200462_a(Character.valueOf('b'), (IItemProvider)Items.field_151133_ar).func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151055_y).func_200465_a("has_item", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151055_y)).func_200465_a("has_item2", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151133_ar)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)ModItems.SKI_STICK_ITEM.get())).func_200472_a(" s ").func_200472_a(" s ").func_200472_a(" n ").func_200462_a(Character.valueOf('s'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('n'), (IItemProvider)Items.field_191525_da).func_200465_a("has_item", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151055_y)).func_200465_a("has_item2", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_191525_da)).func_200464_a(consumer);
        }

        protected void addNbtRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider result, CompoundNBT nbt) {
        }

        protected void addPulloverRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider result, DyeColor color) {
            CompoundNBT subNbt = new CompoundNBT();
            subNbt.func_74768_a("color", color.func_196060_f());
            CompoundNBT customNbt = new CompoundNBT();
            customNbt.func_218657_a("display", (INBT)subNbt);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("w w").func_200472_a("wgw").func_200472_a("www").func_200462_a(Character.valueOf('w'), input).func_200471_a(Character.valueOf('g'), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196116_bh, Items.field_222079_lj})).func_200465_a("has_item", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)input)).func_200467_a(NBTResultFinishedRecipeAdapter.from(consumer, IRecipeSerializer.field_222157_a, customNbt), new ResourceLocation("skiing", result.func_199767_j().toString() + "_from_" + input.func_199767_j().toString()));
        }

        protected void addSkisRecipe(Consumer<IFinishedRecipe> consumer, IItemProvider input, IItemProvider result, SkisEntity.SkisType type) {
            CompoundNBT customNbt = new CompoundNBT();
            customNbt.func_74778_a("Type", type.name());
            System.out.println("creating skis recipe " + type.name());
            ShapedRecipeBuilder.func_200470_a((IItemProvider)result).func_200472_a("p  ").func_200472_a(" p ").func_200472_a("  p").func_200462_a(Character.valueOf('p'), input).func_200465_a("has_item", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)input)).func_200467_a(NBTResultFinishedRecipeAdapter.from(consumer, IRecipeSerializer.field_222157_a, customNbt), new ResourceLocation("skiing", result.func_199767_j().toString() + "_from_" + input.func_199767_j().toString()));
        }

        protected static class NBTResultFinishedRecipeAdapter
        implements IFinishedRecipe {
            protected final IFinishedRecipe recipe;
            protected final IRecipeSerializer<?> serializer;
            private final CompoundNBT data;

            protected NBTResultFinishedRecipeAdapter(IFinishedRecipe recipe, IRecipeSerializer<?> serializer, CompoundNBT data) {
                this.recipe = recipe;
                this.serializer = serializer;
                this.data = data;
            }

            public static Consumer<IFinishedRecipe> from(Consumer<IFinishedRecipe> originalRecipe, IRecipeSerializer<?> serializer, CompoundNBT data) {
                return fr -> originalRecipe.accept(new NBTResultFinishedRecipeAdapter((IFinishedRecipe)fr, serializer, data));
            }

            public static Consumer<IFinishedRecipe> from(Consumer<IFinishedRecipe> originalRecipe, IRecipeSerializer<?> serializer, Consumer<CompoundNBT> data) {
                CompoundNBT nbt = new CompoundNBT();
                data.accept(nbt);
                return NBTResultFinishedRecipeAdapter.from(originalRecipe, serializer, nbt);
            }

            public void func_218610_a(JsonObject json) {
                this.recipe.func_218610_a(json);
                if (null != this.data) {
                    JSONUtils.func_152754_s((JsonObject)json, (String)"result").addProperty("nbt", this.data.toString());
                }
            }

            public ResourceLocation func_200442_b() {
                return this.recipe.func_200442_b();
            }

            public IRecipeSerializer<?> func_218609_c() {
                return this.serializer;
            }

            public JsonObject func_200440_c() {
                return this.recipe.func_200440_c();
            }

            public ResourceLocation func_200443_d() {
                return this.recipe.func_200443_d();
            }
        }
    }

    public static final class ItemModelGen
    extends ItemModelProvider {
        private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
        private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");
        private final Set<Item> blacklist = new HashSet<Item>();
        private final Set<Item> handheld = new HashSet<Item>();

        public ItemModelGen(DataGenerator gen, String modid, ExistingFileHelper existingFileHelper) {
            super(gen, modid, existingFileHelper);
        }

        protected void registerModels() {
            this.blacklist.add((Item)ModItems.SKI_STICK_ITEM.get());
            for (ResourceLocation id : ForgeRegistries.ITEMS.getKeys()) {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
                if (item == null || !"skiing".equals(id.func_110624_b()) || this.blacklist.contains(item)) continue;
                if (item instanceof BlockItem) {
                    this.defaultBlock(id, (BlockItem)item);
                    continue;
                }
                if (this.handheld.contains(item)) {
                    ((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), HANDHELD)).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()));
                    continue;
                }
                this.defaultItem(id, item);
            }
        }

        protected void defaultItem(ResourceLocation id, Item item) {
            if (item instanceof SkisItem) {
                ((ItemModelBuilder)this.getBuilder(id.func_110623_a())).parent((ModelFile)this.getExistingFile(new ResourceLocation(id.func_110624_b(), "item/skis_item_template")));
            } else if (item instanceof PulloverItem) {
                ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), HANDHELD)).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()))).texture("layer1", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a() + "_overlay"));
            } else {
                ((ItemModelBuilder)this.withExistingParent(id.func_110623_a(), GENERATED)).texture("layer0", new ResourceLocation(id.func_110624_b(), "item/" + id.func_110623_a()));
            }
            DATAGEN_LOGGER.debug("Generated item model for: " + item.getRegistryName());
        }

        protected void defaultBlock(ResourceLocation id, BlockItem item) {
            ((ItemModelBuilder)this.getBuilder(id.func_110623_a())).parent((ModelFile)new AlwaysExistingModelFile(new ResourceLocation(id.func_110624_b(), "block/" + id.func_110623_a())));
            DATAGEN_LOGGER.debug("Generated block item model for: " + item.getRegistryName());
        }
    }

    public static final class BlockStateGen
    extends BlockStateProvider {
        public BlockStateGen(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
            super(gen, modid, exFileHelper);
        }

        protected void registerStatesAndModels() {
        }

        public void singleTextureBlock(Block block, String model, String textureName) {
            this.simpleBlock(block);
            DATAGEN_LOGGER.debug("Generated block model for: " + model);
        }
    }

    public static final class LanguageGen
    extends LanguageProvider {
        public final String modID;

        public LanguageGen(DataGenerator gen, String modid, String locale) {
            super(gen, "skiing", locale);
            this.modID = modid;
        }

        protected void addTranslations() {
            String locale;
            switch (locale = this.func_200397_b().replace("Languages: ", "")) {
                case "de_de": {
                    this.add("_comment", "Translation (de_de) by Affehund");
                    this.add((Item)ModItems.SKI_STICK_ITEM.get(), "Skistock");
                    this.add((Item)ModItems.SKIS_ITEM.get(), "Skier");
                    this.add(ModItemGroup.MOD_ITEM_GROUP.func_242392_c().getString(), "Skiing");
                    this.add((EntityType)ModEntities.SKI_ENTITY.get(), "Skier");
                    this.add((Item)ModItems.CHOCOLATE_CUP.get(), "Kakao Tasse");
                    this.add((Item)ModItems.SNOW_SHOVEL.get(), "Schnee Schaufel");
                    this.add((Item)ModItems.PULLOVER.get(), "Pullover");
                    this.addToolTip(this.modID, "snow_shovel", "Mit diesem Gegenstand kannst du eine 3x3-Fl\u00e4che aus Schnee auf einmal abbauen.");
                    this.addToolTip(this.modID, "color", "Farbe");
                    this.addVillager(this.modID, (VillagerProfession)ModVillagers.SKIS_MERCHANT.get(), "Ski H\u00e4ndler");
                    break;
                }
                case "en_us": {
                    this.add("_comment", "Translation (en_us) by Affehund");
                    this.add((Item)ModItems.SKI_STICK_ITEM.get(), "Ski Stick");
                    this.add((Item)ModItems.SKIS_ITEM.get(), "Skis");
                    this.add(ModItemGroup.MOD_ITEM_GROUP.func_242392_c().getString(), "Skiing");
                    this.add((EntityType)ModEntities.SKI_ENTITY.get(), "Skis");
                    this.add((Item)ModItems.CHOCOLATE_CUP.get(), "Chocolate Cup");
                    this.add((Item)ModItems.SNOW_SHOVEL.get(), "Snow Shovel");
                    this.add((Item)ModItems.PULLOVER.get(), "Pullover");
                    this.addToolTip(this.modID, "snow_shovel", "With this item you can break a 3x3 area of snow at once.");
                    this.addToolTip(this.modID, "color", "Color");
                    this.addVillager(this.modID, (VillagerProfession)ModVillagers.SKIS_MERCHANT.get(), "Skis Merchant");
                }
            }
        }

        public void addDisc(Item key, String value) {
            this.add(key.func_77658_a() + ".desc", value);
        }

        public void addToolTip(String modID, String string, String value) {
            this.add(modID + ".tooltip." + string, value);
        }

        public void addVillager(String modID, VillagerProfession villagerProfession, String name) {
            this.add("entity.minecraft.villager." + modID + "." + villagerProfession.toString(), name);
        }
    }
}

