/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.skiing.core.init;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.LegacySingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.template.ProcessorLists;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModVillagers {
    public static final DeferredRegister<PointOfInterestType> POINTS_OF_INTEREST = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"skiing");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"skiing");
    public static RegistryObject<PointOfInterestType> SKIS_MERCHANT_POI = POINTS_OF_INTEREST.register("skis_merchant_poi", () -> new PointOfInterestType("skis_merchant_poi", PointOfInterestType.func_221042_a((Block)Blocks.field_150462_ai), 1, 1));
    public static RegistryObject<VillagerProfession> SKIS_MERCHANT = PROFESSIONS.register("skis_merchant", () -> new VillagerProfession("skis_merchant", (PointOfInterestType)SKIS_MERCHANT_POI.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.field_219694_mB));

    public static void initVillagers() {
        ModVillagers.registerPointOfInterests();
        ModVillagers.registerVillagerHouses();
    }

    private static void registerPointOfInterests() {
        PointOfInterestType.func_221052_a((PointOfInterestType)((PointOfInterestType)SKIS_MERCHANT_POI.get()));
    }

    private static void registerVillagerHouses() {
        SnowyVillagePools.func_214746_a();
        ModVillagers.addToPool(new ResourceLocation("village/snowy/houses"), new ResourceLocation("skiing", "village/snowy_skis_merchant_house_1"), 1);
    }

    private static void addToPool(ResourceLocation pool, ResourceLocation toAdd, int weight) {
        System.out.println("added villager pool: " + toAdd + " to " + pool);
        JigsawPattern old = (JigsawPattern)WorldGenRegistries.field_243656_h.func_82594_a(pool);
        List shuffled = old.func_214943_b(new Random());
        ArrayList<Pair> newPieces = new ArrayList<Pair>();
        for (JigsawPiece p : shuffled) {
            newPieces.add(new Pair((Object)p, (Object)1));
        }
        newPieces.add(Pair.of((Object)new LegacySingleJigsawPiece(Either.left((Object)toAdd), () -> ProcessorLists.field_244101_a, JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        ResourceLocation name = old.func_214947_b();
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243656_h, (ResourceLocation)pool, (Object)new JigsawPattern(pool, name, newPieces));
    }
}

