/*
 * Decompiled with CFR 0.152.
 */
package com.affehund.skiing.core.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SnowShovelUtils {
    public static void breakBlocksInRadius(World world, PlayerEntity playerEntity, int radius) {
        if (!world.field_72995_K) {
            List<BlockPos> blocksToBreak = SnowShovelUtils.getBlocksToBreak(world, playerEntity, radius);
            ItemStack heldItem = playerEntity.func_184614_ca();
            int silktouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem);
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
            for (BlockPos pos : blocksToBreak) {
                BlockState state = world.func_180495_p(pos);
                if (!heldItem.func_77973_b().func_150897_b(state)) continue;
                if (playerEntity.field_71075_bZ.field_75098_d) {
                    if (state.removedByPlayer(world, pos, playerEntity, true, state.func_204520_s())) {
                        state.func_177230_c().func_176206_d((IWorld)world, pos, state);
                    }
                } else {
                    heldItem.func_77973_b().func_179218_a(heldItem, world, state, pos, (LivingEntity)playerEntity);
                    TileEntity tileEntity = world.func_175625_s(pos);
                    state.func_177230_c().func_176206_d((IWorld)world, pos, state);
                    state.func_177230_c().func_180657_a(world, playerEntity, pos, state, tileEntity, heldItem);
                    state.func_177230_c().func_180637_b((ServerWorld)world, pos, state.func_177230_c().getExpDrop(state, (IWorldReader)world, pos, fortune, silktouch));
                }
                world.func_217377_a(pos, false);
                world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                ((ServerPlayerEntity)playerEntity).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
            }
        }
    }

    public static List<BlockPos> getBlocksToBreak(World world, PlayerEntity player, int radius) {
        ArrayList<BlockPos> blocksList = new ArrayList<BlockPos>();
        BlockRayTraceResult rayTraceResult = SnowShovelUtils.getLookingAtBlockRayTrace(world, player);
        if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            Direction.Axis axis = rayTraceResult.func_216354_b().func_176740_k();
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        positions.add(new BlockPos(x, y, z));
                    }
                }
            }
            BlockPos origin = rayTraceResult.func_216350_a();
            for (BlockPos pos : positions) {
                if (axis == Direction.Axis.Y) {
                    if (pos.func_177956_o() != 0) continue;
                    blocksList.add(origin.func_177971_a((Vector3i)pos));
                    continue;
                }
                if (axis == Direction.Axis.X) {
                    if (pos.func_177958_n() != 0) continue;
                    blocksList.add(origin.func_177971_a((Vector3i)pos));
                    continue;
                }
                if (axis != Direction.Axis.Z || pos.func_177952_p() != 0) continue;
                blocksList.add(origin.func_177971_a((Vector3i)pos));
            }
            blocksList.remove(origin);
            blocksList.removeIf(newBlockPos -> world.func_180495_p(newBlockPos).func_177230_c() != world.func_180495_p(origin).func_177230_c());
        }
        return blocksList;
    }

    public static BlockRayTraceResult getLookingAtBlockRayTrace(World world, PlayerEntity player) {
        Vector3d eyePosition = player.func_174824_e(1.0f);
        Vector3d rotation = player.func_70676_i(1.0f);
        Vector3d combined = eyePosition.func_72441_c(rotation.field_72450_a * 5.0, rotation.field_72448_b * 5.0, rotation.field_72449_c * 5.0);
        BlockRayTraceResult rayTraceResult = world.func_217299_a(new RayTraceContext(eyePosition, combined, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player));
        return rayTraceResult;
    }

    public static String getTpStringFromBlockPos(BlockPos pos) {
        return "/tp " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p();
    }
}

