/*
 * Decompiled with CFR 0.152.
 */
package space.bbkr.skychunk.mixin;

import java.util.List;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import space.bbkr.skychunk.Skychunk;

@Mixin(value={ChunkStatus.class})
public class MixinChunkStatus {
    private static final SharedSeedRandom skychunk$random = new SharedSeedRandom();

    @Inject(method={"method_16564", "lambda$static$5"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelNoise(ServerWorld world, ChunkGenerator generator, List<IChunk> list, IChunk chunk, CallbackInfo info) {
        if (MixinChunkStatus.shouldCancel(world, chunk, generator)) {
            info.cancel();
        }
    }

    @Inject(method={"method_16567", "lambda$static$6"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelSurfaceBuilding(ServerWorld world, ChunkGenerator generator, List<IChunk> list, IChunk chunk, CallbackInfo info) {
        if (MixinChunkStatus.shouldCancel(world, chunk, generator)) {
            info.cancel();
        }
    }

    @Inject(method={"method_16569", "lambda$static$8"}, at={@At(value="HEAD")}, cancellable=true)
    private static void cancelLiquidCarvers(ServerWorld world, ChunkGenerator generator, List<IChunk> list, IChunk chunk, CallbackInfo info) {
        info.cancel();
    }

    private static boolean shouldCancel(ServerWorld world, IChunk chunk, ChunkGenerator generator) {
        ChunkPos pos = chunk.func_76632_l();
        if (generator.func_235952_a_(pos) || pos.equals((Object)new ChunkPos(0, 0))) {
            return false;
        }
        skychunk$random.func_202424_a(world.func_72905_C(), pos.field_77276_a, pos.field_77275_b);
        int next = skychunk$random.nextInt(100);
        return next < Skychunk.chunkRemovalRate;
    }
}

