/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakycurses.asm;

import com.fuzs.sneakycurses.SneakyCurses;
import java.util.Arrays;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    private static final String[] classesBeingTransformed = new String[]{"net.minecraft.client.renderer.RenderItem", "net.minecraft.client.renderer.entity.layers.LayerArmorBase"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated = !name.equals(transformedName);
        int index = Arrays.asList(classesBeingTransformed).indexOf(transformedName);
        return index != -1 ? ClassTransformer.transform(index, basicClass, isObfuscated) : basicClass;
    }

    private static byte[] transform(int index, byte[] basicClass, boolean isObfuscated) {
        SneakyCurses.LOGGER.info("Attempting to transform " + classesBeingTransformed[index]);
        try {
            ClassNode classNode = new ClassNode();
            ClassReader classReader = new ClassReader(basicClass);
            classReader.accept((ClassVisitor)classNode, 0);
            switch (index) {
                case 0: {
                    ClassTransformer.transformRenderItem(classNode, isObfuscated);
                    break;
                }
                case 1: {
                    ClassTransformer.transformLayerArmorBase(classNode, isObfuscated);
                }
            }
            ClassWriter classWriter = new ClassWriter(3);
            classNode.accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }

    private static void transformRenderItem(ClassNode playerClass, boolean isObfuscated) {
        String RENDERITEM_RENDERITEM = isObfuscated ? "a" : "renderItem";
        String RENDERITEM_RENDERITEM_DESCRIPTOR = isObfuscated ? "(Laip;Lcfy;)V" : "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/renderer/block/model/IBakedModel;)V";
        String RENDERITEM_RENDEREFFECT = isObfuscated ? "a" : "renderEffect";
        String RENDERITEM_RENDEREFFECT_DESCRIPTOR = isObfuscated ? "(Lcfy;)V" : "(Lnet/minecraft/client/renderer/block/model/IBakedModel;)V";
        boolean flag = false;
        for (MethodNode method : playerClass.methods) {
            if (method.name.equals(RENDERITEM_RENDERITEM) && method.desc.equals(RENDERITEM_RENDERITEM_DESCRIPTOR)) {
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/fuzs/sneakycurses/asm/Hooks", "setTargetStack", isObfuscated ? "(Laip;)V" : "(Lnet/minecraft/item/ItemStack;)V", false));
                method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
                flag = true;
            }
            if (!method.name.equals(RENDERITEM_RENDEREFFECT) || !method.desc.equals(RENDERITEM_RENDEREFFECT_DESCRIPTOR)) continue;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 18 || !((LdcInsnNode)instruction).cst.equals(-8372020)) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/fuzs/sneakycurses/asm/Hooks", "applyColor", "(I)I", false));
                method.instructions.insert(instruction, newInstructions);
                flag = true;
            }
        }
        SneakyCurses.LOGGER.info(flag ? "Transformation successful" : "Transformation failed");
    }

    private static void transformLayerArmorBase(ClassNode playerClass, boolean isObfuscated) {
        String LAYERARMORBASE_RENDERARMORLAYER = isObfuscated ? "a" : "renderArmorLayer";
        String LAYERARMORBASE_RENDERARMORLAYER_DESCRIPTOR = isObfuscated ? "(Lvp;FFFFFFFLvl;)V" : "(Lnet/minecraft/entity/EntityLivingBase;FFFFFFFLnet/minecraft/inventory/EntityEquipmentSlot;)V";
        String LAYERARMORBASE_RENDERENCHANTEDGLINT = isObfuscated ? "a" : "renderEnchantedGlint";
        String LAYERARMORBASE_RENDERENCHANTEDGLINT_DESCRIPTOR = isObfuscated ? "(Lcaa;Lvp;Lbqf;FFFFFFF)V" : "(Lnet/minecraft/client/renderer/entity/RenderLivingBase;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/client/model/ModelBase;FFFFFFF)V";
        boolean flag = false;
        for (MethodNode method : playerClass.methods) {
            if (method.name.equals(LAYERARMORBASE_RENDERARMORLAYER) && method.desc.equals(LAYERARMORBASE_RENDERARMORLAYER_DESCRIPTOR)) {
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                newInstructions.add((AbstractInsnNode)new VarInsnNode(25, 9));
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/fuzs/sneakycurses/asm/Hooks", "setTargetStack", isObfuscated ? "(Lvp;Lvl;)V" : "(Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/inventory/EntityEquipmentSlot;)V", false));
                method.instructions.insertBefore(method.instructions.getFirst(), newInstructions);
                flag = true;
            }
            if (!method.name.equals(LAYERARMORBASE_RENDERENCHANTEDGLINT) || !method.desc.equals(LAYERARMORBASE_RENDERENCHANTEDGLINT_DESCRIPTOR)) continue;
            for (AbstractInsnNode instruction : method.instructions.toArray()) {
                if (instruction.getOpcode() != 184 || !((MethodInsnNode)instruction).owner.equals(isObfuscated ? "bus" : "net/minecraft/client/renderer/GlStateManager") || !((MethodInsnNode)instruction).name.equals(isObfuscated ? "c" : "color") || !((MethodInsnNode)instruction).desc.equals("(FFFF)V") || !((LdcInsnNode)instruction.getPrevious().getPrevious()).cst.equals(Float.valueOf(0.608f))) continue;
                InsnList newInstructions = new InsnList();
                newInstructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/fuzs/sneakycurses/asm/Hooks", "applyColor", "()V", false));
                method.instructions.insert(instruction, newInstructions);
                flag = true;
            }
        }
        SneakyCurses.LOGGER.info(flag ? "Transformation successful" : "Transformation failed");
    }
}

