/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.config;

import com.fuzs.sneakymagic.SneakyMagic;
import com.fuzs.sneakymagic.config.ConfigBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigManager {
    private static ConfigManager instance;
    private final Map<String, ConfigBuilder> configBuilders = Maps.newHashMap();
    private final Set<ConfigEntry<? extends ForgeConfigSpec.ConfigValue<?>, ?>> configEntries = Sets.newHashSet();
    private final Map<Runnable, ConfigLoadState> configListeners = Maps.newHashMap();

    private ConfigManager() {
    }

    public void onModConfig(ModConfig.ModConfigEvent evt) {
        String modid = evt.getConfig().getModId();
        ModConfig.Type type = evt.getConfig().getType();
        if (this.getBuilder(modid).isSpecNotBuilt(type) || this.getBuilder(modid).isSpecNotLoaded(type)) {
            SneakyMagic.LOGGER.error("Unable to get values from config during " + (evt instanceof ModConfig.Loading ? "loading" : "reloading") + " phase: Config spec not present");
        } else {
            this.syncType(modid, type);
            this.notifyListeners(ConfigLoadState.getState(evt));
        }
    }

    public void sync(String modid) {
        this.getEntriesForMod(modid).forEach(ConfigEntry::sync);
    }

    private void syncType(String modid, ModConfig.Type type) {
        this.getEntriesForMod(modid).filter(configValue -> configValue.getType() == type).forEach(ConfigEntry::sync);
    }

    private Stream<ConfigEntry<? extends ForgeConfigSpec.ConfigValue<?>, ?>> getEntriesForMod(String modid) {
        return this.configEntries.stream().filter(entry -> entry.getModId().equals(modid));
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerCommonEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.COMMON, entry, action);
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerClientEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.CLIENT, entry, action);
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerServerEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.SERVER, entry, action);
    }

    private <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerEntry(ModConfig.Type type, S entry, Consumer<T> action) {
        this.configEntries.add(new ConfigEntry<S, T>(type, entry, action, this.getActiveNamespace()));
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerEntry(S entry, Consumer<T> action) {
        ModConfig.Type activeType = this.getBuilder().getActiveType();
        if (activeType == null) {
            SneakyMagic.LOGGER.error("Unable to register config entry: Active builder is null");
        } else if (this.getBuilder().isSpecNotBuilt(activeType)) {
            this.configEntries.add(new ConfigEntry<S, T>(activeType, entry, action, this.getActiveNamespace()));
        } else {
            SneakyMagic.LOGGER.error("Unable to register config entry: Config spec already built");
        }
    }

    public void addListener(Runnable listener) {
        this.addListener(listener, ConfigLoadState.BOTH);
    }

    public void addLoadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoadState.LOADING);
    }

    public void addReloadingListener(Runnable listener) {
        this.addListener(listener, ConfigLoadState.RELOADING);
    }

    private void addListener(Runnable listener, ConfigLoadState state) {
        this.configListeners.merge(listener, state, (state1, state2) -> state1 != state2 ? ConfigLoadState.BOTH : state1);
    }

    private void notifyListeners(ConfigLoadState state) {
        this.configListeners.entrySet().stream().filter(entry -> ((ConfigLoadState)((Object)((Object)entry.getValue()))).matches(state)).map(Map.Entry::getKey).forEach(Runnable::run);
    }

    public static String getConfigName(ModConfig.Type type, String modId) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getConfigNameInFolder(ModConfig.Type type, String modId) {
        return modId + File.separator + ConfigManager.getConfigName(type, modId);
    }

    private String getActiveNamespace() {
        return ModLoadingContext.get().getActiveNamespace();
    }

    private ConfigBuilder getBuilder() {
        return this.getBuilder(this.getActiveNamespace());
    }

    private ConfigBuilder getBuilder(String modid) {
        return this.configBuilders.computeIfAbsent(modid, key -> new ConfigBuilder());
    }

    public static ConfigManager get() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public static ConfigBuilder builder() {
        return ConfigManager.get().getBuilder();
    }

    private static enum ConfigLoadState {
        LOADING,
        RELOADING,
        BOTH;


        boolean matches(ConfigLoadState state) {
            if (state == BOTH || this == BOTH) {
                return true;
            }
            if (state == LOADING && this != RELOADING) {
                return true;
            }
            return state == RELOADING && this != LOADING;
        }

        static ConfigLoadState getState(ModConfig.ModConfigEvent evt) {
            return evt instanceof ModConfig.Loading ? LOADING : RELOADING;
        }
    }

    private static class ConfigEntry<S extends ForgeConfigSpec.ConfigValue<T>, T> {
        final ModConfig.Type type;
        final S entry;
        final Consumer<T> action;
        final String modid;

        ConfigEntry(ModConfig.Type type, S entry, Consumer<T> action, String modid) {
            this.type = type;
            this.entry = entry;
            this.action = action;
            this.modid = modid;
        }

        ModConfig.Type getType() {
            return this.type;
        }

        public String getModId() {
            return this.modid;
        }

        void sync() {
            this.action.accept(this.entry.get());
        }
    }
}

