/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.config;

import com.fuzs.sneakymagic.config.StringListParser;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntryCollectionBuilder<T extends IForgeRegistryEntry<T>>
extends StringListParser<T> {
    public EntryCollectionBuilder(IForgeRegistry<T> registry) {
        super(registry);
    }

    public Set<T> buildEntrySet(List<String> locations) {
        return this.buildEntrySetWithCondition(locations, flag -> true, "");
    }

    public Map<T, Double> buildEntryMap(List<String> locations) {
        return this.buildEntryMapWithCondition(locations, (entry, value) -> true, "");
    }

    public Set<T> buildEntrySetWithCondition(List<String> locations, Predicate<T> condition, String message) {
        HashSet set = Sets.newHashSet();
        for (String source : locations) {
            this.getEntriesFromRegistry(source.trim()).forEach(entry -> {
                if (condition.test(entry)) {
                    if (this.isNotPresent(set, entry)) {
                        set.add(entry);
                    }
                } else {
                    EntryCollectionBuilder.log(source, message);
                }
            });
        }
        return set;
    }

    public Map<T, Double> buildEntryMapWithCondition(List<String> locations, BiPredicate<T, Double> condition, String message) {
        HashMap map = Maps.newHashMap();
        for (String source : locations) {
            String[] splitSource = (String[])Stream.of(source.split(",")).map(String::trim).toArray(String[]::new);
            if (splitSource.length == 2) {
                List entries = this.getEntriesFromRegistry(splitSource[0]);
                if (entries.isEmpty()) continue;
                EntryCollectionBuilder.parseDouble(splitSource[1], source).ifPresent(value -> entries.forEach(entry -> {
                    if (condition.test((T)entry, (Double)value)) {
                        if (this.isNotPresent(map.keySet(), entry)) {
                            map.put(entry, value);
                        }
                    } else {
                        EntryCollectionBuilder.log(source, message);
                    }
                }));
                continue;
            }
            EntryCollectionBuilder.log(source, "Insufficient number of arguments");
        }
        return map;
    }

    private static Optional<Double> parseDouble(String value, String source) {
        try {
            return Optional.of(Double.parseDouble(value));
        }
        catch (NumberFormatException ignored) {
            EntryCollectionBuilder.log(source, "Invalid number format");
            return Optional.empty();
        }
    }
}

