/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.client.handler;

import com.fuzs.sneakymagic.config.ConfigBuildHandler;
import com.fuzs.sneakymagic.mixin.accessor.IItemAccessor;
import com.fuzs.sneakymagic.util.CurseMatcher;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class CursedTooltipHandler {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent evt) {
        Set<Enchantment> enchantments;
        List tooltip = evt.getToolTip();
        ItemStack stack = evt.getItemStack();
        if (!stack.func_190926_b() && (stack.func_77948_v() || ConfigBuildHandler.affectBooks && stack.func_77973_b() == Items.field_151134_bR) && CurseMatcher.anyMatch(enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack).keySet()) && (!ConfigBuildHandler.shiftShows || !Screen.func_231173_s_()) && stack.func_77942_o()) {
            CompoundNBT tag = stack.func_77978_p();
            this.modifyItemName(tooltip, stack, enchantments);
            assert (tag != null);
            this.modifyCurses(tooltip, stack, enchantments, tag);
            if (evt.getFlags().func_194127_a()) {
                this.modifyNbtTag(tooltip, enchantments, tag);
            }
        }
    }

    private void modifyItemName(List<ITextComponent> tooltip, ItemStack stack, Collection<Enchantment> enchantments) {
        boolean disguise;
        boolean bl = disguise = ConfigBuildHandler.disguiseItem && stack.func_77973_b() != Items.field_151134_bR && CurseMatcher.allMatch(enchantments);
        if (disguise || ConfigBuildHandler.colorName) {
            Optional<StringTextComponent> nameComponent = tooltip.stream().filter(component -> component instanceof StringTextComponent).filter(component -> component.func_150261_e().contains(stack.func_200301_q().func_150261_e())).findFirst().map(component -> (StringTextComponent)component);
            nameComponent.ifPresent(component -> component.func_240699_a_(disguise ? ((IItemAccessor)stack.func_77973_b()).getRarity().field_77937_e : TextFormatting.RED));
        }
    }

    private void modifyCurses(List<ITextComponent> tooltip, ItemStack stack, Collection<Enchantment> enchantments, @Nonnull CompoundNBT tag) {
        boolean isHidingEnchantments;
        boolean bl = isHidingEnchantments = tag.func_150297_b("HideFlags", 99) && (tag.func_74762_e("HideFlags") & ItemStack.TooltipDisplayFlags.ENCHANTMENTS.func_242397_a()) == 0;
        if (!(!ConfigBuildHandler.hideCurses || isHidingEnchantments && stack.func_77973_b() != Items.field_151134_bR || stack.func_77973_b() == Items.field_151134_bR && CurseMatcher.allMatch(enchantments))) {
            tooltip.removeIf(component -> this.getCursesAsTooltip(stack).contains(component));
        }
    }

    private void modifyNbtTag(List<ITextComponent> tooltip, Collection<Enchantment> enchantments, @Nonnull CompoundNBT tag) {
        int index;
        if (ConfigBuildHandler.disguiseTag && CurseMatcher.allMatch(enchantments) && (index = tooltip.indexOf(new TranslationTextComponent("item.nbt_tags", new Object[]{tag.func_150296_c().size()}).func_240699_a_(TextFormatting.DARK_GRAY))) != -1) {
            if (tag.func_150296_c().size() > 1) {
                tooltip.set(index, (ITextComponent)new TranslationTextComponent("item.nbt_tags", new Object[]{tag.func_150296_c().size() - 1}).func_240699_a_(TextFormatting.DARK_GRAY));
            } else {
                tooltip.remove(index);
            }
        }
    }

    private List<ITextComponent> getCursesAsTooltip(ItemStack stack) {
        ArrayList curses = Lists.newArrayList();
        EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(entry -> entry.getKey() != null && ((Enchantment)entry.getKey()).func_190936_d()).forEach(entry -> curses.add(((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue())));
        return curses;
    }
}

