/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.config;

import com.fuzs.sneakymagic.SneakyMagic;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public abstract class StringListParser<T extends IForgeRegistryEntry<T>> {
    public static final Logger LOGGER = SneakyMagic.LOGGER;
    private final IForgeRegistry<T> activeRegistry;

    protected StringListParser(IForgeRegistry<T> registry) {
        this.activeRegistry = registry;
    }

    protected final List<T> getEntriesFromRegistry(String source) {
        ArrayList foundEntries = Lists.newArrayList();
        if (source.contains("*")) {
            foundEntries.addAll(this.getWildcardEntries(source));
        } else {
            Optional<ResourceLocation> location = Optional.ofNullable(ResourceLocation.func_208304_a((String)source));
            if (location.isPresent()) {
                Optional<IForgeRegistryEntry> entry = this.getEntryFromRegistry(location.get());
                entry.ifPresent(foundEntries::add);
            } else {
                StringListParser.log(source, "Entry not found");
            }
        }
        return foundEntries;
    }

    private Optional<T> getEntryFromRegistry(ResourceLocation location) {
        if (this.activeRegistry.containsKey(location)) {
            return Optional.ofNullable(this.activeRegistry.getValue(location));
        }
        StringListParser.log(location.toString(), "Entry not found");
        return Optional.empty();
    }

    private List<T> getWildcardEntries(String source) {
        String[] s = source.split(":");
        switch (s.length) {
            case 1: {
                return this.getListFromRegistry("minecraft", s[0]);
            }
            case 2: {
                return this.getListFromRegistry(s[0], s[1]);
            }
        }
        StringListParser.log(source, "Invalid resource location format");
        return Lists.newArrayList();
    }

    private List<T> getListFromRegistry(String namespace, String path) {
        String regexPath = path.replace("*", "[a-z0-9/._-]*");
        List entries = this.activeRegistry.getEntries().stream().filter(entry -> ((RegistryKey)entry.getKey()).getRegistryName().func_110624_b().equals(namespace)).filter(entry -> ((RegistryKey)entry.getKey()).getRegistryName().func_110623_a().matches(regexPath)).map(Map.Entry::getValue).collect(Collectors.toList());
        if (entries.isEmpty()) {
            StringListParser.log(new ResourceLocation(namespace, path).toString(), "Entry not found");
        }
        return entries;
    }

    protected final boolean isNotPresent(Collection<T> collection, T entry) {
        if (collection.contains(entry)) {
            StringListParser.log(Objects.requireNonNull(entry.getRegistryName()).toString(), "Already present");
            return false;
        }
        return true;
    }

    protected static void log(String entry, String message) {
        LOGGER.warn("Unable to parse entry \"{}\": {}", (Object)entry, (Object)message);
    }
}

