/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.client;

import com.fuzs.sneakymagic.config.ConfigBuildHandler;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class CursedTooltipHandler {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent evt) {
        List tooltip = evt.getToolTip();
        ItemStack stack = evt.getItemStack();
        if (!stack.func_190926_b() && (stack.func_77948_v() || ((Boolean)ConfigBuildHandler.AFFECT_BOOKS.get()).booleanValue())) {
            Map<Enchantment, Integer> enchants;
            Map<Enchantment, Integer> map = enchants = (Boolean)ConfigBuildHandler.AFFECT_BOOKS.get() != false ? EnchantmentHelper.func_82781_a((ItemStack)stack) : CursedTooltipHandler.getEnchantments(stack.func_77986_q());
            if (enchants.keySet().stream().filter(Objects::nonNull).anyMatch(Enchantment::func_190936_d) && stack.func_77942_o() && stack.func_77978_p() != null) {
                CompoundNBT tag = stack.func_77978_p();
                boolean noShift = (Boolean)ConfigBuildHandler.SHIFT_SHOWS.get() == false || !Screen.hasShiftDown();
                this.modifyItemName(tooltip, stack, noShift);
                this.modifyCurses(tooltip, stack, tag, noShift);
                this.modifyNbtTags(evt.getFlags().func_194127_a(), tooltip, enchants, tag, noShift);
            }
        }
    }

    private void modifyCurses(List<ITextComponent> tooltip, ItemStack stack, @Nonnull CompoundNBT tag, boolean noShift) {
        boolean flag;
        boolean bl = flag = tag.func_150297_b("HideFlags", 99) && (tag.func_74762_e("HideFlags") & 1) == 0;
        if (((Boolean)ConfigBuildHandler.HIDE_CURSES.get()).booleanValue() && noShift && !flag) {
            tooltip.removeIf(line -> this.getCurseTooltips(stack).contains(line));
        }
    }

    private void modifyItemName(List<ITextComponent> tooltip, ItemStack stack, boolean noShift) {
        if (((Boolean)ConfigBuildHandler.COLOR_NAME.get()).booleanValue() && noShift) {
            Optional<ITextComponent> name = tooltip.stream().filter(line -> line.equals(new StringTextComponent("").func_150257_a(stack.func_200301_q()).func_211708_a(stack.func_77953_t().field_77937_e))).findFirst();
            name.ifPresent(line -> line.func_211708_a(TextFormatting.RED));
        }
    }

    private void modifyNbtTags(boolean isAdvanced, List<ITextComponent> tooltip, Map<Enchantment, Integer> enchants, @Nonnull CompoundNBT tag, boolean noShift) {
        int index;
        if (((Boolean)ConfigBuildHandler.DISGUISE_TAG.get()).booleanValue() && isAdvanced && noShift && enchants.keySet().stream().filter(Objects::nonNull).allMatch(Enchantment::func_190936_d) && (index = tooltip.indexOf(new TranslationTextComponent("item.nbt_tags", new Object[]{tag.func_150296_c().size()}).func_211708_a(TextFormatting.DARK_GRAY))) != -1) {
            if (tag.func_150296_c().size() > 1) {
                tooltip.set(index, new TranslationTextComponent("item.nbt_tags", new Object[]{tag.func_150296_c().size() - 1}).func_211708_a(TextFormatting.DARK_GRAY));
            } else {
                tooltip.remove(index);
            }
        }
    }

    private List<ITextComponent> getCurseTooltips(ItemStack stack) {
        ArrayList curses = Lists.newArrayList();
        EnchantmentHelper.func_82781_a((ItemStack)stack).entrySet().stream().filter(entry -> entry.getKey() != null && ((Enchantment)entry.getKey()).func_190936_d()).forEach(entry -> curses.add(((Enchantment)entry.getKey()).func_200305_d(((Integer)entry.getValue()).intValue())));
        return curses;
    }

    public static Map<Enchantment, Integer> getEnchantments(ListNBT listnbt) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            Optional.ofNullable(ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)compoundnbt.func_74779_i("id")))).ifPresent(p_222185_2_ -> map.put(p_222185_2_, compoundnbt.func_74762_e("lvl")));
        }
        return map;
    }
}

