/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.common;

import com.fuzs.sneakymagic.config.ConfigBuildHandler;
import com.fuzs.sneakymagic.config.StringListBuilder;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraft.item.TridentItem;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class CompatibilityManager {
    private final StringListBuilder<Enchantment> parser = new StringListBuilder(ForgeRegistries.ENCHANTMENTS);
    private final boolean requireRestart = (Boolean)ConfigBuildHandler.REQUIRE_RESTART.get();
    private final Map<ForgeConfigSpec.ConfigValue<List<String>>, Predicate<Item>> types = Maps.newHashMap();
    private final Map<Enchantment, EnchantmentType> defaultTypes = Maps.newHashMap();
    private int typeCounter;

    public CompatibilityManager() {
        this.populate();
        this.sync();
    }

    public void onModConfig(ModConfig.ModConfigEvent evt) {
        if (evt.getConfig().getSpec() == ConfigBuildHandler.SPEC && !this.requireRestart) {
            this.sync();
        }
    }

    private void populate() {
        this.types.put(ConfigBuildHandler.SWORD_ENCHANTS, item -> item instanceof SwordItem);
        this.types.put(ConfigBuildHandler.AXE_ENCHANTS, item -> item instanceof AxeItem);
        this.types.put(ConfigBuildHandler.TRIDENT_ENCHANTS, item -> item instanceof TridentItem);
        this.types.put(ConfigBuildHandler.BOW_ENCHANTS, item -> item instanceof BowItem);
        this.types.put(ConfigBuildHandler.CROSSBOW_ENCHANTS, item -> item instanceof CrossbowItem);
    }

    private void sync() {
        if (!this.requireRestart) {
            this.defaultTypes.forEach((key, value) -> {
                key.field_77351_y = value;
            });
        }
        this.types.forEach((key, value) -> this.parser.buildEntrySet((List)key.get()).forEach(ench -> {
            EnchantmentType type = ench.field_77351_y;
            if (!this.requireRestart) {
                this.defaultTypes.putIfAbsent((Enchantment)ench, type);
            }
            ench.field_77351_y = EnchantmentType.create((String)("sneakymagic".toUpperCase(Locale.ROOT) + "_TYPE_" + this.typeCounter++), item -> type != null && type.func_77557_a(item) || value.test(item));
        }));
    }
}

