/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.common;

import com.fuzs.sneakymagic.config.ConfigBuildHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EnchantmentHandler {
    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent evt) {
        if (evt.getSource().func_76352_a() && ((Boolean)ConfigBuildHandler.NO_PROJECTILE_RESISTANCE.get()).booleanValue()) {
            evt.getEntity().field_70172_ad = 0;
        }
    }

    @SubscribeEvent
    public void onArrowNock(ArrowNockEvent evt) {
        if (((Boolean)ConfigBuildHandler.TRUE_INFINITY.get()).booleanValue() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)evt.getBow()) > 0) {
            evt.getPlayer().func_184598_c(evt.getHand());
            evt.setAction(new ActionResult(ActionResultType.SUCCESS, (Object)evt.getBow()));
        }
    }

    @SubscribeEvent
    public void onRightClickItem(PlayerInteractEvent.RightClickItem evt) {
        ItemStack stack = evt.getPlayer().func_184586_b(evt.getHand());
        if (((Boolean)ConfigBuildHandler.TRUE_INFINITY.get()).booleanValue() && stack.func_77973_b() instanceof CrossbowItem && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0 && !CrossbowItem.func_220012_d((ItemStack)stack)) {
            evt.getPlayer().func_184598_c(evt.getHand());
            evt.setCancellationResult(ActionResultType.SUCCESS);
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPickupXp(PlayerXpEvent.PickupXp evt) {
        ItemStack itemstack;
        if (!((Boolean)ConfigBuildHandler.SELECTIVE_MENDING.get()).booleanValue()) {
            return;
        }
        ExperienceOrbEntity orb = evt.getOrb();
        PlayerEntity entityIn = evt.getPlayer();
        entityIn.field_71090_bL = 2;
        entityIn.func_71001_a((Entity)orb, 1);
        Map.Entry<EquipmentSlotType, ItemStack> entry = this.getRandomItemWithEnchantment((LivingEntity)entityIn);
        if (entry != null && !(itemstack = entry.getValue()).func_190926_b() && itemstack.func_77951_h()) {
            int i = Math.min((int)((float)orb.field_70530_e * itemstack.getXpRepairRatio()), itemstack.func_77952_i());
            orb.field_70530_e -= i / 2;
            itemstack.func_196085_b(itemstack.func_77952_i() - i);
        }
        if (orb.field_70530_e > 0) {
            entityIn.func_195068_e(orb.field_70530_e);
        }
        orb.func_70106_y();
        evt.setCanceled(true);
    }

    private Map.Entry<EquipmentSlotType, ItemStack> getRandomItemWithEnchantment(LivingEntity entityIn) {
        Map map = Enchantments.field_185296_A.func_222181_a(entityIn);
        if (map.isEmpty()) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            ItemStack itemstack = (ItemStack)entry.getValue();
            if (itemstack.func_190926_b() || !itemstack.func_77951_h() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)itemstack) <= 0) continue;
            list.add(entry);
        }
        return list.isEmpty() ? null : (Map.Entry)list.get(entityIn.func_70681_au().nextInt(list.size()));
    }
}

