/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.sneakymagic.config;

import com.fuzs.sneakymagic.config.StringListParser;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StringListBuilder<T extends IForgeRegistryEntry<T>>
extends StringListParser<T> {
    public StringListBuilder(IForgeRegistry<T> registry) {
        super(registry);
    }

    public Set<T> buildEntrySet(List<String> locations) {
        return this.buildEntrySetWithCondition(locations, flag -> true, "");
    }

    public Set<T> buildEntrySetWithCondition(List<String> locations, Predicate<T> condition, String message) {
        HashSet set = Sets.newHashSet();
        for (String source : locations) {
            this.parseResourceLocation(source).flatMap(this::getEntryFromRegistry).ifPresent(entry -> {
                if (condition.test(entry)) {
                    set.add(entry);
                } else {
                    this.logStringParsingError(source, message);
                }
            });
        }
        return set;
    }

    public Map<T, Double> buildEntryMap(List<String> locations) {
        return this.buildEntryMapWithCondition(locations, (entry, value) -> true, "");
    }

    public Map<T, Double> buildEntryMapWithCondition(List<String> locations, BiPredicate<T, Double> condition, String message) {
        HashMap map = Maps.newHashMap();
        for (String source : locations) {
            String[] s = source.split(",");
            if (s.length == 2) {
                Optional entry = this.getEntryFromRegistry(s[0]);
                Optional<Object> size = Optional.empty();
                try {
                    size = Optional.of(Double.parseDouble(s[1]));
                }
                catch (NumberFormatException e) {
                    this.logStringParsingError(source, "Invalid number format");
                }
                if (!entry.isPresent() || !size.isPresent()) continue;
                if (condition.test(entry.get(), (Double)size.get())) {
                    map.put(entry.get(), size.get());
                    continue;
                }
                this.logStringParsingError(source, message);
                continue;
            }
            this.logStringParsingError(source, "Insufficient number of arguments");
        }
        return map;
    }
}

