/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.client;

import com.cazsius.solcarrot.SOLCarrotConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="solcarrot", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class FoodItems {
    private static List<Item> foodsBeforeBlacklist;
    private static List<Item> foods;

    public static List<Item> getAllFoodsIgnoringBlacklist() {
        return new ArrayList<Item>(foodsBeforeBlacklist);
    }

    public static List<Item> getAllFoods() {
        return new ArrayList<Item>(foods);
    }

    @SubscribeEvent
    public static void setUp(FMLCommonSetupEvent event) {
        foodsBeforeBlacklist = ForgeRegistries.ITEMS.getValues().stream().filter(Item::m_41472_).sorted(Comparator.comparing(food -> I18n.m_118938_((String)(food.m_5524_() + ".name"), (Object[])new Object[0]))).collect(Collectors.toList());
        FoodItems.applyBlacklist();
    }

    @SubscribeEvent
    public static void onConfigUpdate(ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            return;
        }
        FoodItems.applyBlacklist();
    }

    private static void applyBlacklist() {
        foods = foodsBeforeBlacklist.stream().filter(SOLCarrotConfig::isAllowed).collect(Collectors.toList());
    }
}

