/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.client.jei;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import someassemblyrequired.client.jei.CuttingRecipeCategory;
import someassemblyrequired.client.jei.ToastingRecipeCategory;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.util.Util;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.prefix("main");

    private static List<IRecipe<?>> findRecipes(IRecipeType<?> recipeType) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> r.func_222127_g() == recipeType).collect(Collectors.toList());
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CuttingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ToastingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (Block cuttingBoard : ModBlocks.getCuttingBoards()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)cuttingBoard), new ResourceLocation[]{CuttingRecipeCategory.ID});
        }
        for (Block toaster : ModBlocks.getToasters()) {
            registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)toaster), new ResourceLocation[]{ToastingRecipeCategory.ID});
        }
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(JEIPlugin.findRecipes(ModRecipeTypes.CUTTING), CuttingRecipeCategory.ID);
        registration.addRecipes(JEIPlugin.findRecipes(ModRecipeTypes.TOASTING), ToastingRecipeCategory.ID);
        registration.addRecipes((Collection)JEIPlugin.findRecipes(IRecipeType.field_222152_d).stream().filter(recipe -> !recipe.func_77571_b().func_190926_b()).collect(Collectors.toList()), ToastingRecipeCategory.ID);
        for (Block block : ModBlocks.getCuttingBoards()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)block), VanillaTypes.ITEM, new String[]{"description.someassemblyrequired.cutting_board"});
        }
        for (Block block : ModBlocks.getSandwichAssemblyTables()) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)block), VanillaTypes.ITEM, new String[]{"description.someassemblyrequired.sandwich_assembly_table"});
        }
        for (Block block : new IItemProvider[]{(IItemProvider)ModBlocks.REDSTONE_TOASTER.get(), (IItemProvider)ModBlocks.STICKY_REDSTONE_TOASTER.get(), (IItemProvider)ModItems.KITCHEN_KNIFE.get(), (IItemProvider)ModItems.BREAD_SLICE.get(), (IItemProvider)ModItems.TOASTED_BREAD_SLICE.get(), (IItemProvider)ModItems.CHARRED_BREAD_SLICE.get(), (IItemProvider)ModItems.CHARRED_FOOD.get(), (IItemProvider)ModItems.APPLE_SLICES.get(), (IItemProvider)ModItems.GOLDEN_APPLE_SLICES.get(), (IItemProvider)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), (IItemProvider)ModItems.CHOPPED_CARROT.get(), (IItemProvider)ModItems.CHOPPED_GOLDEN_CARROT.get(), (IItemProvider)ModItems.CHOPPED_BEETROOT.get(), (IItemProvider)ModItems.PORK_CUTS.get(), (IItemProvider)ModItems.BACON_STRIPS.get(), (IItemProvider)ModItems.TOASTED_CRIMSON_FUNGUS.get(), (IItemProvider)ModItems.SLICED_TOASTED_CRIMSON_FUNGUS.get(), (IItemProvider)ModItems.TOASTED_WARPED_FUNGUS.get(), (IItemProvider)ModItems.SLICED_TOASTED_WARPED_FUNGUS.get(), (IItemProvider)ModItems.TOMATO.get(), (IItemProvider)ModItems.TOMATO_SLICES.get(), (IItemProvider)ModItems.LETTUCE_HEAD.get(), (IItemProvider)ModItems.LETTUCE_LEAF.get(), (IItemProvider)ModItems.MAYONNAISE_BOTTLE.get(), (IItemProvider)ModItems.KETCHUP_BOTTLE.get(), (IItemProvider)ModItems.SWEET_BERRY_JAM_BOTTLE.get()}) {
            registration.addIngredientInfo((Object)new ItemStack((IItemProvider)block), VanillaTypes.ITEM, new String[]{String.format("description.someassemblyrequired.%s", block.func_199767_j().getRegistryName().func_110623_a())});
        }
    }
}

