/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block;

import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import someassemblyrequired.common.block.WaterLoggableHorizontalBlock;
import someassemblyrequired.common.block.tileentity.CuttingBoardTileEntity;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.init.ModTileEntityTypes;

public class CuttingBoardBlock
extends WaterLoggableHorizontalBlock {
    private static final VoxelShape SHAPE_NORTH_SOUTH = Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)14.0);
    private static final VoxelShape SHAPE_EAST_WEST = Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0);

    public CuttingBoardBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public static boolean isKnife(ItemStack stack) {
        return ModTags.TOOLS_KNIVES.func_230235_a_((Object)stack.func_77973_b()) || stack.func_77973_b() instanceof SwordItem;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof CuttingBoardTileEntity)) {
            return ActionResultType.PASS;
        }
        CuttingBoardTileEntity cuttingBoard = (CuttingBoardTileEntity)tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!cuttingBoard.hasIngredient() && !heldItem.func_190926_b()) {
            return this.addIngredient(heldItem, cuttingBoard, world, pos, player, hand) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (heldItem.func_190926_b() && hand == Hand.MAIN_HAND) {
            return this.removeIngredient(cuttingBoard, world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return this.cutIngredient(heldItem, cuttingBoard, world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    private boolean addIngredient(ItemStack ingredient, CuttingBoardTileEntity cuttingBoard, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        if (!player.func_184586_b(Hand.OFF_HAND).func_190926_b() && hand.equals((Object)Hand.MAIN_HAND) && !(player.func_184586_b(hand).func_77973_b() instanceof BlockItem)) {
            return false;
        }
        if (ingredient.func_77973_b() instanceof BlockItem) {
            Block block = ((BlockItem)ingredient.func_77973_b()).func_179223_d();
            SoundType soundType = block.getSoundType(block.func_176223_P(), (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundType.func_185841_e(), SoundCategory.BLOCKS, 0.5f * (soundType.func_185843_a() + 1.0f) / 2.0f, soundType.func_185847_b() * 0.8f);
        } else if (CuttingBoardBlock.isKnife(ingredient)) {
            world.func_184133_a(player, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.5f, 0.8f);
        } else {
            world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f, 0.8f);
        }
        boolean hasAddedIngredient = cuttingBoard.addIngredient(player.func_184812_l_() ? ingredient.func_77946_l() : ingredient);
        assert (hasAddedIngredient);
        return true;
    }

    private boolean cutIngredient(ItemStack tool, CuttingBoardTileEntity cuttingBoard, World world, BlockPos pos, PlayerEntity player) {
        List<ItemStack> results = cuttingBoard.processIngredient(tool);
        if (results.isEmpty()) {
            return false;
        }
        for (ItemStack result : results) {
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, result);
            item.func_174867_a(5);
            world.func_217376_c((Entity)item);
        }
        world.func_184148_a(player, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 0.7f, 0.8f);
        return true;
    }

    private boolean removeIngredient(CuttingBoardTileEntity cuttingBoard, World world, BlockPos pos, PlayerEntity player) {
        ItemStack ingredient = cuttingBoard.removeIngredient();
        if (!ingredient.func_190926_b()) {
            if (!player.func_184812_l_()) {
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, ingredient);
                item.func_174867_a(5);
                world.func_217376_c((Entity)item);
            }
            world.func_184133_a(player, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f, 1.0f);
            return true;
        }
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.CUTTING_BOARD.get()).func_200968_a();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof CuttingBoardTileEntity)) {
            return 0;
        }
        return ((CuttingBoardTileEntity)tileEntity).hasIngredient() ? 15 : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176740_k() == Direction.Axis.X ? SHAPE_EAST_WEST : SHAPE_NORTH_SOUTH;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.func_203425_a(state.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CuttingBoardTileEntity) {
                ItemStack ingredient = ((CuttingBoardTileEntity)tileEntity).removeIngredient();
                if (!ingredient.func_190926_b()) {
                    ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5, ingredient);
                    world.func_217376_c((Entity)item);
                }
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }
}

