/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import someassemblyrequired.common.block.SandwichBlock;
import someassemblyrequired.common.block.tileentity.SandwichAssemblyTableTileEntity;
import someassemblyrequired.common.init.ModAdvancementTriggers;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.init.ModTileEntityTypes;
import someassemblyrequired.common.item.spreadtype.SpreadType;
import someassemblyrequired.common.item.spreadtype.SpreadTypeManager;

public class SandwichAssemblyTableBlock
extends HorizontalBlock {
    public SandwichAssemblyTableBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.SANDWICH_ASSEMBLY_TABLE.get()).func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof SandwichAssemblyTableTileEntity)) {
            return ActionResultType.PASS;
        }
        SandwichAssemblyTableTileEntity sandwichTable = (SandwichAssemblyTableTileEntity)tileEntity;
        if (player.func_225608_bj_()) {
            if (sandwichTable.getAmountOfItems() == 0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.bottom_bread"), true);
            } else if (!sandwichTable.hasBreadAsTopIngredient()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.top_bread"), true);
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 0.5f, 1.4f);
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, SandwichBlock.createSandwich(tileEntity));
                item.func_174867_a(5);
                world.func_217376_c((Entity)item);
                sandwichTable.removeItems();
            }
        } else if (player.func_184586_b(Hand.OFF_HAND).func_190926_b() && player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            if (sandwichTable.getAmountOfItems() > 0) {
                ItemStack ingredient = sandwichTable.removeTopIngredient();
                if (!ingredient.func_190926_b()) {
                    if (!player.func_184812_l_()) {
                        ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, ingredient);
                        item.func_174867_a(5);
                        world.func_217376_c((Entity)item);
                    }
                    world.func_184133_a(player, pos, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.3f, 1.6f);
                } else {
                    world.func_184133_a(player, pos, SoundEvents.field_226135_eP_, SoundCategory.BLOCKS, 0.3f, 1.6f);
                }
            }
        } else if (!this.addIngredient(sandwichTable, world, pos, player, hand)) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addIngredient(SandwichAssemblyTableTileEntity sandwichTable, World world, BlockPos pos, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (sandwichTable.addIngredient(heldStack)) {
            SpreadType spreadType = SpreadTypeManager.INSTANCE.getSpreadType(heldStack.func_77973_b());
            if (spreadType == null) {
                world.func_184133_a(player, pos, SoundEvents.field_187552_ah, SoundCategory.BLOCKS, 0.3f, 1.3f);
            } else {
                world.func_184133_a(player, pos, SoundEvents.field_226138_eS_, SoundCategory.BLOCKS, 0.3f, 1.3f);
                if (player instanceof ServerPlayerEntity && heldStack.func_77973_b() == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)heldStack) != Potions.field_185230_b) {
                    ModAdvancementTriggers.ADD_POTION_TO_SANDWICH.trigger((ServerPlayerEntity)player, heldStack);
                }
            }
            if (player.func_184812_l_()) return true;
            player.func_184586_b(hand).func_190918_g(1);
            if (spreadType == null || !spreadType.hasContainer(heldStack)) return true;
            ItemStack container = new ItemStack((IItemProvider)spreadType.getContainer(heldStack), 1);
            if (player.func_184586_b(hand).func_190926_b()) {
                player.func_184611_a(hand, container);
                return true;
            } else {
                player.func_191521_c(container);
            }
            return true;
        } else {
            if (!heldStack.func_222117_E() && heldStack.func_77973_b() != ModItems.SPREAD.get() && !SpreadTypeManager.INSTANCE.hasSpreadType(heldStack.func_77973_b())) return false;
            if (sandwichTable.getAmountOfItems() == 0 && !ModTags.SANDWICH_BREADS.func_230235_a_((Object)heldStack.func_77973_b())) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.bottom_bread"), true);
                return true;
            } else {
                if (sandwichTable.getAmountOfItems() != sandwichTable.getInventorySize()) return false;
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.full_sandwich"), true);
            }
        }
        return true;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.func_203425_a(state.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SandwichAssemblyTableTileEntity) {
                for (ItemStack ingredient : ((SandwichAssemblyTableTileEntity)tileEntity).removeItems()) {
                    ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, ingredient);
                    world.func_217376_c((Entity)item);
                }
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
            for (int slot = 0; slot < handler.getSlots() && slot <= 15; ++slot) {
                if (!handler.getStackInSlot(slot).func_190926_b()) continue;
                return slot;
            }
            return 15;
        }
        return 0;
    }
}

