/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block.tileentity;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import someassemblyrequired.common.block.CuttingBoardBlock;
import someassemblyrequired.common.block.tileentity.ItemHandlerTileEntity;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.init.ModTileEntityTypes;

public class CuttingBoardTileEntity
extends ItemHandlerTileEntity {
    private boolean hasKnife;

    public CuttingBoardTileEntity() {
        super((TileEntityType<? extends ItemHandlerTileEntity>)((TileEntityType)ModTileEntityTypes.CUTTING_BOARD.get()), 1);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (side == null || side == Direction.DOWN || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }

    public ItemStack getIngredient() {
        return this.getInventory().getStackInSlot(0);
    }

    public boolean addIngredient(ItemStack stack) {
        if (!stack.func_190926_b() && this.getIngredient().func_190926_b()) {
            this.getInventory().insertItem(0, stack.func_77979_a(1), false);
            return true;
        }
        return false;
    }

    public boolean hasIngredient() {
        return !this.getIngredient().func_190926_b();
    }

    public boolean hasKnife() {
        return this.hasKnife;
    }

    public ItemStack removeIngredient() {
        return this.getInventory().extractItem(0, 1, false);
    }

    public List<ItemStack> processIngredient(ItemStack tool) {
        if (this.field_145850_b == null) {
            return Collections.emptyList();
        }
        return this.field_145850_b.func_199532_z().func_215370_b(ModRecipeTypes.CUTTING, (IInventory)new RecipeWrapper((IItemHandlerModifiable)this.getInventory()), this.field_145850_b).stream().filter(cuttingRecipe -> cuttingRecipe.getTool().test(tool)).map(recipe -> recipe.getRecipeOutputs()).peek(list -> this.removeIngredient()).findFirst().orElse(Collections.emptyList());
    }

    @Override
    protected void onContentsUpdated() {
        this.hasKnife = CuttingBoardBlock.isKnife(this.getIngredient());
    }

    @Override
    protected ItemHandlerTileEntity.TileEntityItemHandler createItemHandler(int size) {
        return new IngredientHandler(size);
    }

    private class IngredientHandler
    extends ItemHandlerTileEntity.TileEntityItemHandler {
        protected IngredientHandler(int size) {
            super(CuttingBoardTileEntity.this, size);
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            result.func_196083_e("IsOnSandwich");
            return result;
        }

        @Override
        public NonNullList<ItemStack> removeItems() {
            NonNullList result = NonNullList.func_191196_a();
            for (ItemStack ingredient : super.removeItems()) {
                ingredient.func_196083_e("IsOnSandwich");
                result.add((Object)ingredient);
            }
            return result;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack ingredient = stack.func_77946_l();
            ingredient.func_196082_o().func_74757_a("IsOnSandwich", true);
            return super.insertItem(slot, ingredient, simulate);
        }
    }
}

