/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block.tileentity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import someassemblyrequired.common.block.RedstoneToasterBlock;
import someassemblyrequired.common.block.tileentity.ItemHandlerTileEntity;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.init.ModTileEntityTypes;

public class RedstoneToasterTileEntity
extends ItemHandlerTileEntity
implements ITickableTileEntity {
    private static final int TOASTING_TIME = 240;
    private static final int SMOKE_PARTICLES_TIME = 80;
    private int toastingProgress;
    private int smokeParticlesProgress;
    private boolean isEjectionToaster;
    @Nullable
    private UUID playerToasting;

    public RedstoneToasterTileEntity() {
        super((TileEntityType<? extends ItemHandlerTileEntity>)((TileEntityType)ModTileEntityTypes.REDSTONE_TOASTER.get()), 2);
    }

    public void setAutoEject(boolean isEjectionToaster) {
        this.isEjectionToaster = isEjectionToaster;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (side == null || side == Direction.DOWN || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(capability, side);
        }
        return LazyOptional.empty();
    }

    private boolean hasMetalInside() {
        return this.getItems().stream().anyMatch(stack -> ModTags.TOASTER_METALS.func_230235_a_((Object)stack.func_77973_b()));
    }

    public void explode() {
        if (this.field_145850_b != null && !this.field_145850_b.func_201670_d()) {
            PlayerEntity player = this.playerToasting == null ? null : this.field_145850_b.func_217371_b(this.playerToasting);
            NonNullList<ItemStack> items = this.removeItems();
            this.field_145850_b.func_217377_a(this.field_174879_c, true);
            this.field_145850_b.func_217398_a((Entity)player, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 2.2f, true, Explosion.Mode.DESTROY);
            for (ItemStack stack : items) {
                ItemEntity entity = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                entity.func_174869_p();
                entity.func_213317_d(entity.func_213322_ci().func_186678_a(2.5));
                this.field_145850_b.func_217376_c((Entity)entity);
            }
        }
    }

    public ItemStack removeItem() {
        int slot = !this.getInventory().getStackInSlot(0).func_190926_b() ? 0 : 1;
        return this.getInventory().extractItem(slot, 1, false);
    }

    public boolean addItem(ItemStack stack) {
        int slot;
        if (this.getInventory().getStackInSlot(0).func_190926_b()) {
            if (!this.getInventory().getStackInSlot(1).func_190926_b()) {
                return false;
            }
            slot = 0;
        } else {
            slot = 1;
        }
        if (stack.func_190916_E() != this.getInventory().insertItem(slot, stack.func_77946_l(), false).func_190916_E()) {
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public ItemStack getItem(int slot) {
        return this.getInventory().getStackInSlot(slot);
    }

    private boolean hasToastingResult(ItemStack ingredient) {
        return !this.getToastingResult(ingredient).func_190926_b();
    }

    private ItemStack getToastingResult(ItemStack ingredient) {
        if (ingredient.func_190926_b() || ingredient.func_77973_b() == ModItems.CHARRED_MORSEL.get() || this.field_145850_b == null) {
            return ItemStack.field_190927_a;
        }
        Inventory ingredientWrapper = new Inventory(new ItemStack[]{ingredient});
        Optional toastingRecipe = this.field_145850_b.func_199532_z().func_215371_a(ModRecipeTypes.TOASTING, (IInventory)ingredientWrapper, this.field_145850_b);
        IRecipe recipe = null;
        if (toastingRecipe.isPresent()) {
            recipe = (IRecipe)toastingRecipe.get();
        } else {
            Optional smokingRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)ingredientWrapper, this.field_145850_b);
            if (smokingRecipe.isPresent()) {
                recipe = (IRecipe)smokingRecipe.get();
            }
        }
        if (recipe == null) {
            if (ingredient.func_77973_b().func_219971_r()) {
                if (ModTags.SMALL_FOODS.func_230235_a_((Object)ingredient.func_77973_b())) {
                    return new ItemStack((IItemProvider)ModItems.CHARRED_MORSEL.get());
                }
                return new ItemStack((IItemProvider)ModItems.CHARRED_FOOD.get());
            }
            return ItemStack.field_190927_a;
        }
        return recipe.func_77572_b((IInventory)ingredientWrapper);
    }

    private void toastItems() {
        if (this.field_145850_b == null) {
            return;
        }
        for (int slot = 0; slot < this.getInventory().getSlots(); ++slot) {
            ItemStack result = this.getToastingResult(this.getInventory().getStackInSlot(slot));
            if (result.func_190926_b()) continue;
            this.getInventory().setStackInSlot(slot, result);
        }
    }

    public boolean startToasting(PlayerEntity entity) {
        this.playerToasting = entity.func_110124_au();
        if (this.field_145850_b != null && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            this.explode();
        }
        return this.startToasting();
    }

    public boolean startToasting() {
        if (this.field_145850_b == null || this.isToasting()) {
            return false;
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.5f, 0.8f);
        if (this.hasMetalInside()) {
            this.explode();
            return true;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)RedstoneToasterBlock.TOASTING)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneToasterBlock.TOASTING, (Comparable)Boolean.valueOf(true)));
        }
        this.toastingProgress = 240;
        if (this.smokeParticlesProgress > 0) {
            this.smokeParticlesProgress = 320;
        }
        return true;
    }

    private void stopToasting() {
        this.toastItems();
        this.playerToasting = null;
        if (this.field_145850_b == null) {
            return;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)RedstoneToasterBlock.TOASTING)) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)RedstoneToasterBlock.TOASTING, (Comparable)Boolean.valueOf(false)));
        }
        if (this.isEjectionToaster) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.8f);
            for (ItemStack ingredient : this.removeItems()) {
                ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, ingredient);
                item.func_174869_p();
                item.func_213317_d(item.func_213322_ci().func_216372_d(0.5, 2.0, 0.5));
                this.field_145850_b.func_217376_c((Entity)item);
            }
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_193807_ew, SoundCategory.BLOCKS, 0.8f, 4.0f);
    }

    public boolean isToasting() {
        return this.toastingProgress > 0;
    }

    @Override
    protected boolean canModifyItems() {
        return super.canModifyItems() && !this.isToasting();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        super.func_230337_a_(state, compoundNBT);
        this.toastingProgress = compoundNBT.func_74762_e("ToastingProgress");
        this.smokeParticlesProgress = compoundNBT.func_74762_e("SmokeParticlesProgress");
        this.isEjectionToaster = compoundNBT.func_74767_n("IsEjectionToaster");
        if (compoundNBT.func_186855_b("PlayerToasting")) {
            this.playerToasting = compoundNBT.func_186857_a("PlayerToasting");
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_74768_a("ToastingProgress", this.toastingProgress);
        compoundNBT.func_74768_a("SmokeParticlesProgress", this.smokeParticlesProgress);
        compoundNBT.func_74757_a("IsEjectionToaster", this.isEjectionToaster);
        if (this.playerToasting != null) {
            compoundNBT.func_186854_a("PlayerToasting", this.playerToasting);
        }
        return super.func_189515_b(compoundNBT);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.isToasting()) {
            if (--this.toastingProgress <= 0) {
                this.stopToasting();
            } else if (this.toastingProgress % 4 == 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.05f, this.toastingProgress % 8 == 0 ? 2.0f : 1.9f);
            }
        }
        if (this.toastingProgress == 80) {
            this.smokeParticlesProgress = 160;
        }
        if (this.smokeParticlesProgress > 0 && this.smokeParticlesProgress-- % 3 == 0) {
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + 0.5, 0.0, 0.03, 0.0);
        }
    }

    @Override
    protected ItemHandlerTileEntity.TileEntityItemHandler createItemHandler(int size) {
        return new ItemHandlerTileEntity.TileEntityItemHandler(size){

            @Override
            public boolean isItemValid(int slot, ItemStack stack) {
                return super.isItemValid(slot, stack) && stack.func_77973_b() != ModItems.SANDWICH.get() && (stack.func_77973_b().func_219971_r() || !(stack.func_77973_b() instanceof BlockItem) || RedstoneToasterTileEntity.this.hasToastingResult(stack));
            }
        };
    }
}

