/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import someassemblyrequired.common.block.tileentity.ItemHandlerTileEntity;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.init.ModTileEntityTypes;
import someassemblyrequired.common.item.spreadtype.SpreadType;
import someassemblyrequired.common.item.spreadtype.SpreadTypeManager;

public class SandwichAssemblyTableTileEntity
extends ItemHandlerTileEntity {
    private final SandwichItemHandler sandwichInventory = this.createSandwichItemHandler();
    private final LazyOptional<SandwichItemHandler> sandwichItemHandler = LazyOptional.of(() -> this.sandwichInventory);

    public SandwichAssemblyTableTileEntity() {
        super((TileEntityType<? extends ItemHandlerTileEntity>)((TileEntityType)ModTileEntityTypes.SANDWICH_ASSEMBLY_TABLE.get()), 16);
    }

    private ItemStack createSpreadItem(SpreadType spreadType, ItemStack ingredient) {
        CompoundNBT spreadNBT = new CompoundNBT();
        spreadNBT.func_74768_a("Color", spreadType.getColor(ingredient));
        spreadNBT.func_74757_a("HasEffect", ingredient.func_77962_s());
        spreadNBT.func_218657_a("Ingredient", (INBT)ingredient.func_77946_l().func_77979_a(1).func_77955_b(new CompoundNBT()));
        NonNullList<ItemStack> ingredients = this.getItems();
        for (int slot = ingredients.size() - 1; slot >= 0; --slot) {
            if (!ModTags.SANDWICH_BREADS.func_230235_a_((Object)((ItemStack)ingredients.get(slot)).func_77973_b())) continue;
            if (!ModTags.BREAD.func_230235_a_((Object)((ItemStack)ingredients.get(slot)).func_77973_b())) break;
            spreadNBT.func_74757_a("IsOnLoaf", true);
            break;
        }
        ItemStack spread = new ItemStack((IItemProvider)ModItems.SPREAD.get());
        spread.func_77982_d(spreadNBT);
        return spread;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null && side.func_176740_k().func_200128_b()) {
            return this.sandwichItemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public ItemStack removeTopIngredient() {
        if (this.getAmountOfItems() > 0) {
            return this.getInventory().extractItem(this.getAmountOfItems() - 1, 1, false);
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasBreadAsTopIngredient() {
        if (this.getAmountOfItems() > 0) {
            return ModTags.SANDWICH_BREADS.func_230235_a_((Object)this.getInventory().getStackInSlot(this.getAmountOfItems() - 1).func_77973_b());
        }
        return false;
    }

    public int getInventorySize() {
        return this.getInventory().getSlots();
    }

    public boolean addIngredient(ItemStack stack) {
        SpreadType spreadType = SpreadTypeManager.INSTANCE.getSpreadType(stack.func_77973_b());
        ItemStack ingredient = spreadType == null ? stack.func_77946_l() : this.createSpreadItem(spreadType, stack);
        int nextEmptySlot = this.getAmountOfItems();
        if (nextEmptySlot >= this.getInventorySize() || !this.getInventory().isItemValid(nextEmptySlot, ingredient)) {
            return false;
        }
        int count = this.getInventory().insertItem(nextEmptySlot, ingredient, false).func_190916_E();
        return count != ingredient.func_190916_E();
    }

    @Override
    protected void onContentsUpdated() {
        this.sandwichInventory.update();
    }

    private SandwichItemHandler createSandwichItemHandler() {
        return new SandwichItemHandler();
    }

    @Override
    protected ItemHandlerTileEntity.TileEntityItemHandler createItemHandler(int size) {
        return new IngredientHandler(size);
    }

    private class IngredientHandler
    extends ItemHandlerTileEntity.TileEntityItemHandler {
        private IngredientHandler(int size) {
            super(size);
        }

        @Override
        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        public NonNullList<ItemStack> removeItems() {
            NonNullList result = NonNullList.func_191196_a();
            for (ItemStack ingredient : super.removeItems()) {
                if (ingredient.func_77973_b() == ModItems.SPREAD.get()) continue;
                ingredient.func_196083_e("IsOnSandwich");
                result.add((Object)ingredient);
            }
            return result;
        }

        @Override
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.validateSlotIndex(slot);
            if (slot < this.getSlots() - 1 && !this.getStackInSlot(slot + 1).func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (result.func_77973_b() == ModItems.SPREAD.get()) {
                return ItemStack.field_190927_a;
            }
            result.func_196083_e("IsOnSandwich");
            return result;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot != 0 && this.getStackInSlot(slot - 1).func_190926_b() || slot >= this.getSlots() || !this.getStackInSlot(slot).func_190926_b()) {
                return false;
            }
            if (stack.func_77973_b() == ModItems.SANDWICH.get()) {
                int sandwichSize;
                IItemHandler itemHandler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
                for (sandwichSize = 0; sandwichSize < itemHandler.getSlots() && !itemHandler.getStackInSlot(sandwichSize).func_190926_b(); ++sandwichSize) {
                }
                return sandwichSize > 0 && sandwichSize <= this.getSlots() - SandwichAssemblyTableTileEntity.this.getAmountOfItems();
            }
            return !(!stack.func_222117_E() && stack.func_77973_b() != ModItems.SPREAD.get() && !SpreadTypeManager.INSTANCE.hasSpreadType(stack.func_77973_b()) || slot <= 0 && !ModTags.SANDWICH_BREADS.func_230235_a_((Object)stack.func_77973_b()));
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            this.validateSlotIndex(slot);
            if (stack.func_77973_b() == ModItems.SANDWICH.get()) {
                stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(sandwichItemHandler -> {
                    int slotOffset = SandwichAssemblyTableTileEntity.this.getAmountOfItems();
                    for (int sandwichSlot = 0; sandwichSlot < sandwichItemHandler.getSlots() && !sandwichItemHandler.getStackInSlot(sandwichSlot).func_190926_b(); ++sandwichSlot) {
                        this.setStackInSlot(slotOffset + sandwichSlot, sandwichItemHandler.getStackInSlot(sandwichSlot));
                    }
                });
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - 1));
            }
            SpreadType spreadType = SpreadTypeManager.INSTANCE.getSpreadType(stack.func_77973_b());
            ItemStack ingredient = spreadType == null ? stack.func_77946_l() : SandwichAssemblyTableTileEntity.this.createSpreadItem(spreadType, stack);
            ingredient.func_196082_o().func_74757_a("IsOnSandwich", true);
            if (!simulate && spreadType != null && SandwichAssemblyTableTileEntity.this.func_145831_w() != null && spreadType.hasContainer(ingredient)) {
                ItemEntity item = new ItemEntity(SandwichAssemblyTableTileEntity.this.func_145831_w(), (double)SandwichAssemblyTableTileEntity.this.field_174879_c.func_177958_n() + 0.5, (double)SandwichAssemblyTableTileEntity.this.field_174879_c.func_177956_o() + 1.2, (double)SandwichAssemblyTableTileEntity.this.field_174879_c.func_177952_p() + 0.5, new ItemStack((IItemProvider)spreadType.getContainer(ingredient)));
                item.func_174867_a(5);
                SandwichAssemblyTableTileEntity.this.func_145831_w().func_217376_c((Entity)item);
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)super.insertItem(slot, ingredient, simulate).func_190916_E());
        }
    }

    private class SandwichItemHandler
    implements IItemHandler {
        private ItemStack sandwich = ItemStack.field_190927_a;

        private SandwichItemHandler() {
        }

        public void update() {
            int nextEmptySlot = SandwichAssemblyTableTileEntity.this.getAmountOfItems();
            if (nextEmptySlot < 2 || !ModTags.SANDWICH_BREADS.func_230235_a_((Object)SandwichAssemblyTableTileEntity.this.getInventory().getStackInSlot(nextEmptySlot - 1).func_77973_b())) {
                this.sandwich = ItemStack.field_190927_a;
            } else {
                this.sandwich = new ItemStack((IItemProvider)ModItems.SANDWICH.get());
                SandwichAssemblyTableTileEntity.this.func_189515_b(this.sandwich.func_190925_c("BlockEntityTag"));
            }
        }

        protected void validateSlotIndex(int slot) {
            if (slot != 0) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0,1)");
            }
        }

        public int getSlots() {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            this.validateSlotIndex(slot);
            return this.sandwich;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.sandwich.func_190926_b() || amount <= 0) {
                return ItemStack.field_190927_a;
            }
            this.validateSlotIndex(slot);
            ItemStack result = this.sandwich;
            if (!simulate) {
                SandwichAssemblyTableTileEntity.this.removeItems();
            }
            return result;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 && SandwichAssemblyTableTileEntity.this.getInventory().isItemValid(SandwichAssemblyTableTileEntity.this.getAmountOfItems(), stack);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            this.validateSlotIndex(slot);
            return SandwichAssemblyTableTileEntity.this.getInventory().insertItem(SandwichAssemblyTableTileEntity.this.getAmountOfItems(), stack, simulate);
        }
    }
}

