/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import someassemblyrequired.common.init.ModAdvancementTriggers;
import someassemblyrequired.common.util.SandwichBuilder;
import someassemblyrequired.common.util.SandwichIngredientHelper;
import someassemblyrequired.common.util.SandwichNameHelper;

public class SandwichItem
extends BlockItem {
    public SandwichItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            int size;
            for (size = 0; size < handler.getSlots() && !handler.getStackInSlot(size).func_190926_b(); ++size) {
            }
            for (int slot = size - 1; slot >= 0; --slot) {
                if (slot < size - 8 && size >= 10) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.someassemblyrequired.truncate_info", new Object[]{size - 8}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
                    return;
                }
                tooltip.add((ITextComponent)handler.getStackInSlot(slot).func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GRAY));
            }
        });
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            items.add((Object)SandwichBuilder.blt());
        }
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            return super.func_195941_b(context, state);
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        List<ItemStack> ingredients = SandwichIngredientHelper.getIngredients(stack);
        if (entity instanceof ServerPlayerEntity) {
            if (SandwichIngredientHelper.isDoubleDeckerSandwich(ingredients)) {
                ModAdvancementTriggers.CONSUME_DOUBLE_DECKER_SANDWICH.trigger((ServerPlayerEntity)entity, stack);
            } else if (SandwichIngredientHelper.isBLT(SandwichIngredientHelper.getUniqueIngredientsExcludingBread(ingredients))) {
                ModAdvancementTriggers.CONSUME_BLT_SANDWICH.trigger((ServerPlayerEntity)entity, stack);
            }
        }
        for (ItemStack ingredient : ingredients) {
            ItemStack finishStack = ingredient.func_77973_b().func_77654_b(ingredient, world, entity);
            if (!(entity instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)entity;
            if (player.func_184811_cZ().func_185141_a(ingredient.func_77973_b())) {
                player.func_184811_cZ().func_185145_a((Item)this, 20);
            }
            if (player.func_184812_l_() || finishStack.func_190926_b()) continue;
            player.func_191521_c(finishStack);
        }
        return super.func_77654_b(stack, world, entity);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        if (stack.func_82837_s()) {
            return super.func_200295_i(stack);
        }
        return SandwichNameHelper.getSandwichDisplayName(stack);
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT compoundNBT) {
        return new ICapabilityProvider(){
            private final LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);

            private IItemHandler createHandler() {
                IngredientItemHandler handler = new IngredientItemHandler(stack);
                handler.deserializeNBT(stack.func_190925_c("BlockEntityTag").func_74775_l("Ingredients"));
                return handler;
            }

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.handler.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    private static class IngredientItemHandler
    extends ItemStackHandler {
        private final ItemStack sandwichItem;

        private IngredientItemHandler(ItemStack sandwichItem) {
            super(0);
            this.sandwichItem = sandwichItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        protected void onContentsChanged(int slot) {
            this.sandwichItem.func_190925_c("BlockEntityTag").func_218657_a("Ingredients", (INBT)this.serializeNBT());
        }
    }
}

