/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.item.spreadtype;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.common.item.spreadtype.SpreadType;

public class SimpleSpreadType
extends SpreadType {
    private final Item container;
    private final ITextComponent displayName;
    private final int color;

    public SimpleSpreadType(Item ingredient, Item container, ITextComponent displayName, int color) {
        super(ingredient);
        this.container = container;
        this.displayName = displayName;
        this.color = color;
    }

    @Override
    public Item getContainer(ItemStack stack) {
        return this.container;
    }

    @Override
    public int getColor(ItemStack stack) {
        return this.color;
    }

    protected static SimpleSpreadType deserialize(JsonObject object) {
        IFormattableTextComponent displayName;
        if (!object.has("item")) {
            throw new JsonParseException("Ingredient item must be set");
        }
        String itemName = object.get("item").getAsString();
        if (!ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemName))) {
            throw new JsonParseException(String.format("Expected to find item but got '%s'", itemName));
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName));
        if (item == Items.field_190931_a) {
            throw new JsonParseException("Ingredient item can not be air");
        }
        Item containerItem = Items.field_190931_a;
        if (object.has("container")) {
            String containerName = object.get("container").getAsString();
            if (ForgeRegistries.ITEMS.containsKey(new ResourceLocation(containerName))) {
                containerItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(containerName));
            } else {
                throw new JsonParseException(String.format("Expected to find item but got '%s'", containerName));
            }
        }
        if ((displayName = ITextComponent.Serializer.func_240641_a_((JsonElement)object.get("displayname"))) == null) {
            throw new JsonParseException("Display name must be set");
        }
        if (!object.has("color")) {
            throw new JsonParseException("Color must be set");
        }
        int color = object.get("color").getAsInt();
        return new SimpleSpreadType(item, containerItem, (ITextComponent)displayName, color);
    }

    public static SimpleSpreadType read(PacketBuffer buffer) {
        Item ingredient = (Item)ForgeRegistries.ITEMS.getValue(buffer.func_192575_l());
        Item container = buffer.readBoolean() ? (Item)ForgeRegistries.ITEMS.getValue(buffer.func_192575_l()) : Items.field_190931_a;
        ITextComponent displayName = buffer.func_179258_d();
        int color = buffer.readInt();
        return new SimpleSpreadType(ingredient, container, displayName, color);
    }

    @Override
    public ITextComponent getDisplayName(ItemStack stack) {
        return this.displayName;
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.getIngredient().getRegistryName());
        if (this.container == Items.field_190931_a) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_192572_a(this.container.getRegistryName());
        }
        buffer.func_179256_a(this.displayName);
        buffer.writeInt(this.color);
    }
}

