/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.item.spreadtype;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.PacketDistributor;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.common.item.spreadtype.PotionSpreadType;
import someassemblyrequired.common.item.spreadtype.SimpleSpreadType;
import someassemblyrequired.common.item.spreadtype.SpreadType;
import someassemblyrequired.common.network.NetworkHandler;
import someassemblyrequired.common.network.SpreadTypeSyncPacket;

public class SpreadTypeManager
extends JsonReloadListener {
    public static final SpreadTypeManager INSTANCE = new SpreadTypeManager();
    private Map<ResourceLocation, SimpleSpreadType> spreadTypes = Collections.emptyMap();
    private Map<Item, SpreadType> spreadTypeLookup = Collections.emptyMap();

    private SpreadTypeManager() {
        super(new Gson(), "someassemblyrequired/spread_types");
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, IResourceManager resourceManager, IProfiler profiler) {
        HashMap spreadTypes = Maps.newHashMap();
        object.forEach((resourceLocation, element) -> {
            try {
                if (element.isJsonObject() && !CraftingHelper.processConditions((JsonObject)element.getAsJsonObject(), (String)"conditions")) {
                    SomeAssemblyRequired.LOGGER.debug("Skipping loading spread type {} as it's conditions were not met", resourceLocation);
                    return;
                }
                JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)element, (String)"spread type");
                SimpleSpreadType spreadType = SimpleSpreadType.deserialize(jsonobject);
                if (spreadTypes.values().stream().anyMatch(s -> s.getIngredient() == spreadType.getIngredient())) {
                    SomeAssemblyRequired.LOGGER.warn("Multiple spread types found for item {}", (Object)spreadType.getIngredient());
                }
                spreadTypes.put(resourceLocation, spreadType);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                SomeAssemblyRequired.LOGGER.error("Parsing error loading custom spread type {}: {}", resourceLocation, (Object)exception.getMessage());
            }
        });
        SomeAssemblyRequired.LOGGER.info("Loaded {} spread types", (Object)spreadTypes.size());
        boolean isServer = true;
        try {
            LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        }
        catch (Exception exception) {
            isServer = false;
        }
        if (isServer) {
            this.sendSyncingPackets();
        }
        this.setSpreadTypes(spreadTypes);
    }

    @Nullable
    public SpreadType getSpreadType(Item item) {
        return this.spreadTypeLookup.get(item);
    }

    public boolean hasSpreadType(Item item) {
        return this.spreadTypeLookup.containsKey(item);
    }

    public void setSpreadTypes(Map<ResourceLocation, SimpleSpreadType> spreadTypes) {
        this.spreadTypes = spreadTypes;
        this.refreshSpreadTypeLookup();
    }

    private void refreshSpreadTypeLookup() {
        this.spreadTypeLookup = new HashMap<Item, SpreadType>();
        this.spreadTypeLookup.put(Items.field_151068_bn, new PotionSpreadType());
        for (SpreadType spreadType : this.spreadTypes.values()) {
            this.spreadTypeLookup.put(spreadType.getIngredient(), spreadType);
        }
    }

    private void sendSyncingPackets() {
        NetworkHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SpreadTypeSyncPacket(this.spreadTypes));
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)event.getPlayer()), (Object)new SpreadTypeSyncPacket(this.spreadTypes));
        }
    }
}

