/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.recipe.SingleIngredientRecipe;

public class CuttingRecipe
extends SingleIngredientRecipe {
    private final Ingredient tool;
    private final NonNullList<ItemStack> results;

    public CuttingRecipe(ResourceLocation id, String group, Ingredient input, Ingredient tool, NonNullList<ItemStack> results) {
        super(ModRecipeTypes.CUTTING, id, group, input);
        this.tool = tool;
        this.results = results;
    }

    public ItemStack func_77572_b(IInventory inventory) {
        return ((ItemStack)this.results.get(0)).func_77946_l();
    }

    public ItemStack func_77571_b() {
        return (ItemStack)this.results.get(0);
    }

    public NonNullList<ItemStack> getRecipeOutputs() {
        NonNullList results = NonNullList.func_191196_a();
        for (ItemStack stack : this.results) {
            results.add((Object)stack.func_77946_l());
        }
        return results;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipeTypes.CUTTING_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CuttingRecipe> {
        public CuttingRecipe read(ResourceLocation id, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            Ingredient ingredient = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient"));
            Ingredient tool = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"tool"));
            NonNullList results = NonNullList.func_191196_a();
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"result")) {
                for (JsonElement resultItem : JSONUtils.func_151214_t((JsonObject)json, (String)"result")) {
                    results.add((Object)ShapedRecipe.func_199798_a((JsonObject)resultItem.getAsJsonObject()));
                }
            } else {
                results.add((Object)ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result")));
            }
            return new CuttingRecipe(id, group, ingredient, tool, (NonNullList<ItemStack>)results);
        }

        @Nullable
        public CuttingRecipe read(ResourceLocation id, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient tool = Ingredient.func_199566_b((PacketBuffer)buffer);
            int size = buffer.func_150792_a();
            NonNullList results = NonNullList.func_191196_a();
            for (int i = 0; i < size; ++i) {
                results.add((Object)buffer.func_150791_c());
            }
            return new CuttingRecipe(id, group, input, tool, (NonNullList<ItemStack>)results);
        }

        public void write(PacketBuffer buffer, CuttingRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            recipe.tool.func_199564_a(buffer);
            buffer.func_150787_b(recipe.results.size());
            for (ItemStack result : recipe.results) {
                buffer.func_150788_a(result);
            }
        }
    }
}

