/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModTags;
import someassemblyrequired.common.util.SandwichIngredientHelper;

public class SandwichNameHelper {
    private static final Set<Item> INGREDIENT_NAME_OVERRIDES = new HashSet<Item>(Arrays.asList((Item)ModItems.TOASTED_BREAD_SLICE.get(), (Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.PORK_CUTS.get(), (Item)ModItems.BACON_STRIPS.get(), (Item)ModItems.SLICED_TOASTED_CRIMSON_FUNGUS.get(), (Item)ModItems.SLICED_TOASTED_WARPED_FUNGUS.get(), (Item)ModItems.TOMATO_SLICES.get(), (Item)ModItems.LETTUCE_LEAF.get()));

    public static ITextComponent getSandwichDisplayName(ItemStack sandwich) {
        ItemStack spreadItem;
        IItemHandler handler = (IItemHandler)sandwich.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int slot = 0; slot < handler.getSlots() && !handler.getStackInSlot(slot).func_190926_b(); ++slot) {
            ingredients.add(handler.getStackInSlot(slot));
        }
        int amountOfBread = SandwichNameHelper.getAmountOfBread(ingredients);
        if (ingredients.size() == amountOfBread) {
            return SandwichNameHelper.getBreadSandwichName(ingredients);
        }
        List<ItemStack> uniqueIngredients = SandwichIngredientHelper.getUniqueIngredientsExcludingBread(ingredients);
        if (SandwichIngredientHelper.isBLT(uniqueIngredients)) {
            return new TranslationTextComponent("item.someassemblyrequired.blt_sandwich");
        }
        if (uniqueIngredients.size() == 1 && uniqueIngredients.get(0).func_77973_b() == ModItems.SPREAD.get() && uniqueIngredients.get(0).func_196082_o().func_74764_b("Ingredient") && (spreadItem = ItemStack.func_199557_a((CompoundNBT)uniqueIngredients.get(0).func_190925_c("Ingredient"))).func_77973_b() == Items.field_151068_bn) {
            Potion potion = PotionUtils.func_185191_c((ItemStack)spreadItem);
            if (potion == Potions.field_185230_b) {
                return new TranslationTextComponent("item.someassemblyrequired.soggy_sandwich");
            }
            if (potion.func_185170_a().size() == 1) {
                return new TranslationTextComponent("item.someassemblyrequired.potion_sandwich", new Object[]{((EffectInstance)potion.func_185170_a().get(0)).func_188419_a().func_199286_c()});
            }
        }
        if (uniqueIngredients.size() > 0 && uniqueIngredients.size() <= 3) {
            ITextComponent ingredientList = SandwichNameHelper.listIngredients(uniqueIngredients);
            if (SandwichIngredientHelper.isDoubleDeckerSandwich(ingredients)) {
                return new TranslationTextComponent("item.someassemblyrequired.double_decker_ingredients_sandwich", new Object[]{ingredientList});
            }
            return new TranslationTextComponent("item.someassemblyrequired.ingredients_sandwich", new Object[]{ingredientList});
        }
        if (SandwichIngredientHelper.isDoubleDeckerSandwich(ingredients)) {
            return new TranslationTextComponent("item.someassemblyrequired.double_decker_sandwich");
        }
        return new TranslationTextComponent("item.someassemblyrequired.sandwich");
    }

    private static int getAmountOfBread(List<ItemStack> ingredients) {
        int result = 0;
        for (ItemStack ingredient : ingredients) {
            if (!ModTags.SANDWICH_BREADS.func_230235_a_((Object)ingredient.func_77973_b())) continue;
            ++result;
        }
        return result;
    }

    private static ITextComponent getBreadSandwichName(List<ItemStack> ingredients) {
        if (ingredients.size() == 3 && ingredients.get(0).func_77973_b() != ModItems.TOASTED_BREAD_SLICE.get() && ingredients.get(1).func_77973_b() == ModItems.TOASTED_BREAD_SLICE.get() && ingredients.get(2).func_77973_b() != ModItems.TOASTED_BREAD_SLICE.get()) {
            return new TranslationTextComponent("item.someassemblyrequired.ingredients_sandwich", new Object[]{SandwichNameHelper.getIngredientDisplayName(ingredients.get(1))});
        }
        return new TranslationTextComponent("item.someassemblyrequired.bread_sandwich");
    }

    private static ITextComponent getIngredientDisplayName(ItemStack ingredient) {
        if (!ingredient.func_82837_s() && INGREDIENT_NAME_OVERRIDES.contains(ingredient.func_77973_b())) {
            return new TranslationTextComponent(String.format("ingredient.%s.%s", ingredient.func_77973_b().getRegistryName().func_110624_b(), ingredient.func_77973_b().getRegistryName().func_110623_a()));
        }
        return ingredient.func_200301_q();
    }

    private static ITextComponent listIngredients(List<ItemStack> ingredients) {
        List ingredientNames = ingredients.stream().map(SandwichNameHelper::getIngredientDisplayName).collect(Collectors.toList());
        return new TranslationTextComponent("tooltip.someassemblyrequired.ingredient_list." + ingredientNames.size(), ingredientNames.toArray());
    }
}

