/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import someassemblyrequired.common.block.RedstoneToasterBlock;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.util.Util;

public class BlockStates
extends BlockStateProvider {
    public BlockStates(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "someassemblyrequired", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        ModelBuilder sandwichModel = ((BlockModelBuilder)this.models().getBuilder(this.prefixBlock("sandwich").toString())).texture("particle", this.prefixItem("bread_slice"));
        this.horizontalBlock((Block)ModBlocks.SANDWICH.get(), arg_0 -> BlockStates.lambda$registerStatesAndModels$0((ModelFile)sandwichModel, arg_0), new Property[]{BlockStateProperties.field_208198_y});
        this.getVariantBuilder((Block)ModBlocks.LETTUCE.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.createLettuceModel((Integer)state.func_177229_b((Property)((CropsBlock)ModBlocks.LETTUCE.get()).func_185524_e()))).build());
        this.createTomatoesBaseModel();
        this.getVariantBuilder((Block)ModBlocks.TOMATOES.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(this.createTomatoesModel((Integer)state.func_177229_b((Property)((CropsBlock)ModBlocks.TOMATOES.get()).func_185524_e()))).build());
        ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/sandwich_assembly_table", "cube")).texture("down", "#bottom")).texture("up", this.prefixBlock("sandwich_assembly_table_top"))).texture("north", "#side")).texture("south", "#front")).texture("east", "#side")).texture("west", "#side")).texture("particle", "#side")).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 45.0f, 0.0f).scale(0.625f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 315.0f, 0.0f).scale(0.4f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().end();
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/cutting_board", "thin_block")).texture("particle", "#texture")).element().from(1.0f, 0.0f, 2.0f).to(15.0f, 1.0f, 14.0f).allFaces((direction, face) -> face.texture("#texture")).end();
        this.sandwichAssemblyTable((Block)ModBlocks.OAK_SANDWICH_ASSEMBLY_TABLE.get(), "oak");
        this.sandwichAssemblyTable((Block)ModBlocks.SPRUCE_SANDWICH_ASSEMBLY_TABLE.get(), "spruce");
        this.sandwichAssemblyTable((Block)ModBlocks.BIRCH_SANDWICH_ASSEMBLY_TABLE.get(), "birch");
        this.sandwichAssemblyTable((Block)ModBlocks.JUNGLE_SANDWICH_ASSEMBLY_TABLE.get(), "jungle");
        this.sandwichAssemblyTable((Block)ModBlocks.ACACIA_SANDWICH_ASSEMBLY_TABLE.get(), "acacia");
        this.sandwichAssemblyTable((Block)ModBlocks.DARK_OAK_SANDWICH_ASSEMBLY_TABLE.get(), "dark_oak");
        this.sandwichAssemblyTable((Block)ModBlocks.CRIMSON_SANDWICH_ASSEMBLY_TABLE.get(), "crimson");
        this.sandwichAssemblyTable((Block)ModBlocks.WARPED_SANDWICH_ASSEMBLY_TABLE.get(), "warped");
        this.cuttingBoard((Block)ModBlocks.OAK_CUTTING_BOARD.get(), "oak", "log");
        this.cuttingBoard((Block)ModBlocks.SPRUCE_CUTTING_BOARD.get(), "spruce", "log");
        this.cuttingBoard((Block)ModBlocks.BIRCH_CUTTING_BOARD.get(), "birch", "log");
        this.cuttingBoard((Block)ModBlocks.JUNGLE_CUTTING_BOARD.get(), "jungle", "log");
        this.cuttingBoard((Block)ModBlocks.ACACIA_CUTTING_BOARD.get(), "acacia", "log");
        this.cuttingBoard((Block)ModBlocks.DARK_OAK_CUTTING_BOARD.get(), "dark_oak", "log");
        this.cuttingBoard((Block)ModBlocks.CRIMSON_CUTTING_BOARD.get(), "crimson", "stem");
        this.cuttingBoard((Block)ModBlocks.WARPED_CUTTING_BOARD.get(), "warped", "stem");
        this.toaster((Block)ModBlocks.REDSTONE_TOASTER.get());
        this.toaster((Block)ModBlocks.STICKY_REDSTONE_TOASTER.get());
    }

    private ResourceLocation prefixBlock(String path) {
        return Util.prefix("block/" + path);
    }

    private ResourceLocation prefixItem(String path) {
        return Util.prefix("item/" + path);
    }

    private void horizontalBlock(Block block, Function<BlockState, ModelFile> modelFunction, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply((BlockState)state)).rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).build(), ignored);
    }

    private void sandwichAssemblyTable(Block block, String woodType) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + woodType + "_sandwich_assembly_table", this.prefixBlock("sandwich_assembly_table"))).texture("front", this.prefixBlock(woodType + "_sandwich_assembly_table_front"))).texture("side", this.prefixBlock(woodType + "_sandwich_assembly_table_side"))).texture("bottom", new ResourceLocation("block/" + woodType + "_planks"));
        this.horizontalBlock(block, arg_0 -> BlockStates.lambda$sandwichAssemblyTable$5((ModelFile)model, arg_0));
    }

    private void cuttingBoard(Block block, String woodType, String logName) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent("block/" + woodType + "_cutting_board", this.prefixBlock("cutting_board"))).texture("texture", new ResourceLocation("block/stripped_" + woodType + "_" + logName));
        this.horizontalBlock(block, arg_0 -> BlockStates.lambda$cuttingBoard$6((ModelFile)model, arg_0), new Property[]{BlockStateProperties.field_208198_y});
    }

    private void toaster(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().rotationY(((int)((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180) % 360).modelFile((ModelFile)this.models().getExistingFile(this.prefixBlock((Boolean)state.func_177229_b((Property)RedstoneToasterBlock.TOASTING) != false ? "toasting_redstone_toaster" : "idle_redstone_toaster"))).build(), new Property[]{BlockStateProperties.field_208198_y, BlockStateProperties.field_208194_u});
    }

    private ModelFile createLettuceModel(int growthStage) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(this.prefixBlock("lettuce_stage" + growthStage).toString())).ao(false)).texture("crop", this.prefixBlock("lettuce_stage" + growthStage))).texture("particle", this.prefixItem("lettuce_head"));
        if (growthStage > 0) {
            int height = growthStage + 1 + (growthStage >= 3 ? 1 : 0);
            model.element().from((float)(8 - growthStage), -1.0f, (float)(8 - growthStage)).to((float)(8 + growthStage), (float)(-1 + height), (float)(8 + growthStage)).face(Direction.NORTH).end().face(Direction.EAST).end().face(Direction.SOUTH).end().face(Direction.WEST).end().faces((direction, face) -> face.uvs((float)growthStage, 8.0f, (float)(growthStage * 2), 8.0f + (float)height / 2.0f)).face(Direction.UP).uvs(0.0f, 8.0f, (float)growthStage, (float)(8 + growthStage)).end().texture("#crop");
        }
        this.addCropLeaves(model, 8, growthStage, 45.0f, element -> element.faces((faceDirection, face) -> {
            int offset = faceDirection.func_176743_c() == Direction.AxisDirection.POSITIVE ? 4 : 0;
            face.uvs(0.0f, (float)offset, 8.0f, (float)(4 + offset));
        }));
        return model;
    }

    private ModelFile createTomatoesModel(int growthStage) {
        return ((BlockModelBuilder)this.models().withExistingParent(this.prefixBlock("tomatoes_stage" + growthStage).toString(), this.prefixBlock("tomatoes"))).texture("crop", this.prefixBlock("tomatoes_stage" + growthStage));
    }

    private void createTomatoesBaseModel() {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder("block/tomatoes")).ao(false)).texture("particle", "#crop")).texture("pole", this.prefixBlock("tomatoes_pole"))).element().from(7.0f, -1.0f, 7.0f).to(9.0f, 15.0f, 9.0f).face(Direction.NORTH).end().face(Direction.EAST).end().face(Direction.SOUTH).end().face(Direction.WEST).end().faces((direction, face) -> face.uvs((float)(direction.func_176736_b() * 2), 0.0f, (float)(direction.func_176736_b() * 2 + 2), 16.0f)).face(Direction.UP).uvs(8.0f, 0.0f, 10.0f, 2.0f).end().texture("#pole").end();
        this.addCropLeaves(model, 16, 2, 0.0f, element -> element.faces((direction, face) -> face.uvs(0.0f, 0.0f, 16.0f, 16.0f)));
    }

    private void addCropLeaves(BlockModelBuilder model, int size, int offsetFromOrigin, float angle, Consumer<ModelBuilder.ElementBuilder> consumer) {
        Direction.Plane.HORIZONTAL.func_239636_a_().forEach(direction -> {
            int axisDirectionSign = direction.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : -1;
            int xWidth = direction.func_176740_k() == Direction.Axis.Z ? 16 * axisDirectionSign : 0;
            int yWidth = direction.func_176740_k() == Direction.Axis.X ? 16 * axisDirectionSign : 0;
            int leafOriginY = -1;
            int leafOriginX = direction.func_176740_k() == Direction.Axis.X ? 8 - offsetFromOrigin * axisDirectionSign : 8;
            int leafOriginZ = direction.func_176740_k() == Direction.Axis.Z ? 8 + offsetFromOrigin * axisDirectionSign : 8;
            ModelBuilder.ElementBuilder element = model.element().shade(false).from((float)leafOriginX - (float)xWidth / 2.0f, (float)leafOriginY, (float)leafOriginZ + (float)yWidth / 2.0f).to((float)leafOriginX + (float)xWidth / 2.0f, (float)(leafOriginY + size), (float)leafOriginZ - (float)yWidth / 2.0f).rotation().origin((float)leafOriginX, (float)leafOriginY, (float)leafOriginZ).angle(angle * (float)axisDirectionSign).axis(direction.func_176746_e().func_176740_k()).end().face(direction).end().face(direction.func_176734_d()).end().texture("#crop");
            consumer.accept(element);
        });
    }

    private static /* synthetic */ ModelFile lambda$cuttingBoard$6(ModelFile model, BlockState $) {
        return model;
    }

    private static /* synthetic */ ModelFile lambda$sandwichAssemblyTable$5(ModelFile model, BlockState $) {
        return model;
    }

    private static /* synthetic */ ModelFile lambda$registerStatesAndModels$0(ModelFile sandwichModel, BlockState $) {
        return sandwichModel;
    }
}

