/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.util.Util;

public class ItemModels
extends ItemModelProvider {
    public ItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "someassemblyrequired", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getRegistryName().func_110624_b().equals("someassemblyrequired")).collect(Collectors.toSet());
        ItemModels.removeAll(items, (IItemProvider)ModItems.SANDWICH.get());
        ItemModels.removeAll(items, (IItemProvider)ModItems.KITCHEN_KNIFE.get());
        this.addHandHeldModel((Item)ModItems.KITCHEN_KNIFE.get());
        ItemModels.removeAll(items, (IItemProvider)ModItems.SPREAD.get());
        this.addGeneratedModel("spread_on_loaf", this.prefixItem("spread_on_loaf"));
        this.addGeneratedModel((Item)ModItems.SPREAD.get()).override().model((ModelFile)this.getExistingFile(this.prefixItem("spread_on_loaf"))).predicate(Util.prefix("on_loaf"), 1.0f).end();
        ItemModels.removeAll(items, (IItemProvider)ModItems.APPLE_SLICES.get(), (IItemProvider)ModItems.GOLDEN_APPLE_SLICES.get(), (IItemProvider)ModItems.CHOPPED_CARROT.get(), (IItemProvider)ModItems.CHOPPED_GOLDEN_CARROT.get(), (IItemProvider)ModItems.CHOPPED_BEETROOT.get(), (IItemProvider)ModItems.PORK_CUTS.get(), (IItemProvider)ModItems.BACON_STRIPS.get(), (IItemProvider)ModItems.SLICED_TOASTED_CRIMSON_FUNGUS.get(), (IItemProvider)ModItems.SLICED_TOASTED_WARPED_FUNGUS.get(), (IItemProvider)ModItems.TOMATO_SLICES.get(), (IItemProvider)ModItems.LETTUCE_LEAF.get()).forEach(item -> {
            String itemName = item.getRegistryName().func_110623_a();
            this.addGeneratedModel(itemName + "_on_sandwich", this.prefixItem(itemName + "_on_sandwich"));
            this.addGeneratedModel(itemName, this.prefixItem(itemName)).override().model((ModelFile)this.getExistingFile(this.prefixItem(itemName + "_on_sandwich"))).predicate(Util.prefix("on_sandwich"), 1.0f).end();
        });
        ItemModels.removeAll(items, (IItemProvider)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get());
        this.addGeneratedModel("enchanted_golden_apple_slices", this.prefixItem("golden_apple_slices")).override().model((ModelFile)this.getExistingFile(this.prefixItem("golden_apple_slices_on_sandwich"))).predicate(Util.prefix("on_sandwich"), 1.0f).end();
        for (Item toaster : ItemModels.removeAll(items, (IItemProvider[])ModBlocks.getToasters())) {
            this.withExistingParent(toaster.getRegistryName().func_110623_a(), this.prefixBlock("idle_redstone_toaster"));
        }
        ItemModels.removeAll(items, (IItemProvider)ModItems.LETTUCE_SEEDS.get(), (IItemProvider)ModItems.TOMATO_SEEDS.get()).forEach(this::addGeneratedModel);
        ItemModels.removeAll(items, (T item) -> item instanceof BlockItem).forEach(block -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)this.withExistingParent(block.getRegistryName().func_110623_a(), this.prefixBlock(block.getRegistryName().func_110623_a()));
        });
        items.forEach(this::addGeneratedModel);
    }

    private ResourceLocation prefixBlock(String path) {
        return Util.prefix("block/" + path);
    }

    private ResourceLocation prefixItem(String path) {
        return Util.prefix("item/" + path);
    }

    private void addHandHeldModel(Item item) {
        ((ItemModelBuilder)this.withExistingParent("item/" + item.getRegistryName().func_110623_a(), "item/handheld")).texture("layer0", this.prefixItem(item.getRegistryName().func_110623_a()));
    }

    private ItemModelBuilder addGeneratedModel(Item item) {
        String name = item.getRegistryName().func_110623_a();
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent("item/" + name, "item/generated")).texture("layer0", this.prefixItem(name));
    }

    private ItemModelBuilder addGeneratedModel(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", texture);
    }

    private static Collection<Item> removeAll(Set<Item> set, IItemProvider ... items) {
        Set<Item> result = Arrays.stream(items).map(IItemProvider::func_199767_j).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() != items.length) {
            throw new IllegalArgumentException();
        }
        return result;
    }

    private static <T> Collection<T> removeAll(Set<T> set, Predicate<T> pred) {
        Set result = set.stream().filter(pred).collect(Collectors.toSet());
        set.removeAll(result);
        if (result.size() <= 0) {
            throw new IllegalArgumentException();
        }
        return result;
    }
}

