/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.EmptyLootEntry;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.SurvivesExplosion;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import someassemblyrequired.common.init.ModBlocks;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.util.Util;

public class LootTables
extends LootTableProvider {
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = new ArrayList<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>>();

    public LootTables(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        this.tables.clear();
        for (Block block : ModBlocks.getSandwichAssemblyTables()) {
            this.addStandardDropTable(block);
        }
        for (Block block : ModBlocks.getCuttingBoards()) {
            this.addStandardDropTable(block);
        }
        for (Block block : ModBlocks.getToasters()) {
            this.addStandardDropTable(block);
        }
        this.addBlockLootTable((Block)ModBlocks.LETTUCE.get(), LootTables.createCropWithBonusSeedsLootTable((CropsBlock)ModBlocks.LETTUCE.get(), (Item)ModItems.LETTUCE_HEAD.get(), (Item)ModItems.LETTUCE_SEEDS.get()));
        this.addBlockLootTable((Block)ModBlocks.TOMATOES.get(), LootTables.createSeedCropLootTable((CropsBlock)ModBlocks.TOMATOES.get(), (Item)ModItems.TOMATO.get(), (Item)ModItems.TOMATO_SEEDS.get()));
        this.addChestLootTables();
        return this.tables;
    }

    private void addChestLootTables() {
        this.addChestLootTable("inject/chests/village/village_desert_house", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.itemEntry((Item)ModItems.TOMATO.get(), 6, 2, 6)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/village/village_savanna_house", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.itemEntry((Item)ModItems.TOMATO.get(), 4, 1, 3)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 1, 1, 3)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 1, 1, 3)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/village/village_plains_house", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.itemEntry((Item)ModItems.TOMATO.get(), 3, 1, 4)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 1, 1, 4)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 2, 1, 4)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/village/village_taiga_house", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.itemEntry((Item)ModItems.TOMATO.get(), 2, 1, 3)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 2, 1, 3)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 2, 1, 3)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/village/village_snowy_house", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 2, 2, 6)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 4, 2, 6)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/igloo_chest", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 6, 1, 4)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 6, 1, 4)).func_216045_a(LootTables.emptyEntry(12))));
        this.addChestLootTable("inject/chests/shipwreck_supply", LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().name("main").func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)2)).func_216045_a(LootTables.itemEntry((Item)ModItems.TOMATO.get(), 4, 2, 6)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_HEAD.get(), 1, 2, 6)).func_216045_a(LootTables.itemEntry((Item)ModItems.LETTUCE_SEEDS.get(), 1, 2, 6)).func_216045_a(LootTables.emptyEntry(12))));
    }

    private static LootTable.Builder createCropWithBonusSeedsLootTable(CropsBlock cropsBlock, Item cropItem, Item seedItem) {
        ILootCondition.IBuilder condition = LootTables.createAgeCondition(cropsBlock);
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)cropItem).func_212840_b_(condition)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seedItem)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(condition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seedItem).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
    }

    private static LootTable.Builder createSeedCropLootTable(CropsBlock cropsBlock, Item cropItem, Item seedItem) {
        ILootCondition.IBuilder condition = LootTables.createAgeCondition(cropsBlock);
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(Inverted.func_215979_a((ILootCondition.IBuilder)condition)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seedItem))).func_216040_a(LootPool.func_216096_a().func_212840_b_(condition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)cropItem))).func_216040_a(LootPool.func_216096_a().func_212840_b_(condition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)cropItem).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b());
    }

    private static ILootCondition.IBuilder createAgeCondition(CropsBlock cropsBlock) {
        return BlockStateProperty.func_215985_a((Block)cropsBlock).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)cropsBlock.func_185524_e(), ((Integer)cropsBlock.func_185524_e().func_177700_c().stream().max(Integer::compare).get()).intValue()));
    }

    private static LootEntry.Builder<?> itemEntry(Item item, int weight, int min, int max) {
        return ItemLootEntry.func_216168_a((IItemProvider)item).func_216086_a(weight).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
    }

    private static LootEntry.Builder<?> emptyEntry(int weight) {
        return EmptyLootEntry.func_216167_a().func_216086_a(weight);
    }

    private void addStandardDropTable(Block block) {
        this.addBlockLootTable(block, LootTable.func_216119_b().func_216040_a(this.createStandardDrops((IItemProvider)block)));
    }

    private void addBlockLootTable(Block block, LootTable.Builder lootTable) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(block.func_220068_i(), lootTable), (Object)LootParameterSets.field_216267_h));
    }

    private void addChestLootTable(String location, LootTable.Builder lootTable) {
        this.tables.add((Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>)Pair.of(() -> lootBuilder -> lootBuilder.accept(Util.prefix(location), lootTable), (Object)LootParameterSets.field_216266_g));
    }

    private LootPool.Builder createStandardDrops(IItemProvider itemProvider) {
        return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(SurvivesExplosion.func_215968_b()).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)itemProvider));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((loc, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)loc, (LootTable)table));
    }
}

