/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import someassemblyrequired.common.init.ModItems;
import someassemblyrequired.common.init.ModRecipeTypes;
import someassemblyrequired.common.init.ModTags;

public class CuttingRecipeBuilder {
    private final Ingredient ingredient;
    private final Ingredient tool;
    private final Map<Item, Integer> results = new LinkedHashMap<Item, Integer>();

    private CuttingRecipeBuilder(Ingredient ingredient, Ingredient tool) {
        this.ingredient = ingredient;
        this.tool = tool;
    }

    public static void addCuttingRecipes(Consumer<IFinishedRecipe> consumer) {
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e})).addResult((IItemProvider)ModItems.APPLE_SLICES.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151025_P})).addResult((IItemProvider)ModItems.BREAD_SLICE.get(), 4).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_185164_cV})).addResult((IItemProvider)ModItems.CHOPPED_BEETROOT.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF})).addResult((IItemProvider)ModItems.CHOPPED_CARROT.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151150_bK})).addResult((IItemProvider)ModItems.CHOPPED_GOLDEN_CARROT.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196100_at})).addResult((IItemProvider)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151153_ao})).addResult((IItemProvider)ModItems.GOLDEN_APPLE_SLICES.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.LETTUCE_HEAD.get()})).addResult((IItemProvider)ModItems.LETTUCE_LEAF.get(), 3).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221794_dg})).addResult((IItemProvider)Items.field_151127_ba, 9).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151147_al})).addResult((IItemProvider)ModItems.PORK_CUTS.get(), 3).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.TOASTED_CRIMSON_FUNGUS.get()})).addResult((IItemProvider)ModItems.SLICED_TOASTED_CRIMSON_FUNGUS.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)ModItems.TOASTED_WARPED_FUNGUS.get()})).addResult((IItemProvider)ModItems.SLICED_TOASTED_WARPED_FUNGUS.get(), 2).build(consumer);
        CuttingRecipeBuilder.cuttingRecipe(Ingredient.func_199805_a(ModTags.CROPS_TOMATOES)).addResult((IItemProvider)ModItems.TOMATO_SLICES.get(), 2).build(consumer, "someassemblyrequired:cutting/tomato_slices");
    }

    public static CuttingRecipeBuilder cuttingRecipe(Ingredient ingredient) {
        return CuttingRecipeBuilder.cuttingRecipe(ingredient, Ingredient.func_199805_a(ModTags.TOOLS_KNIVES));
    }

    public static CuttingRecipeBuilder cuttingRecipe(Ingredient ingredient, Ingredient tool) {
        return new CuttingRecipeBuilder(ingredient, tool);
    }

    public CuttingRecipeBuilder addResult(IItemProvider result, int count) {
        this.results.put(result.func_199767_j(), count);
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        String name = ((Item)this.results.keySet().stream().findFirst().get()).getRegistryName().func_110623_a();
        this.build(consumer, "someassemblyrequired:cutting/" + name);
    }

    public void build(Consumer<IFinishedRecipe> consumer, String save) {
        this.build(consumer, new ResourceLocation(save));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.ingredient, this.tool, this.results));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final Ingredient tool;
        private final Map<Item, Integer> results;

        public Result(ResourceLocation id, Ingredient ingredient, Ingredient tool, Map<Item, Integer> results) {
            this.id = id;
            this.ingredient = ingredient;
            this.tool = tool;
            this.results = results;
        }

        public void func_218610_a(JsonObject object) {
            object.add("ingredient", this.ingredient.func_200304_c());
            object.add("tool", this.tool.func_200304_c());
            if (this.results.size() == 1) {
                object.add("result", (JsonElement)this.serializeResult((Map.Entry)this.results.entrySet().stream().findFirst().get()));
            } else {
                JsonArray array = new JsonArray();
                for (Map.Entry<Item, Integer> result : this.results.entrySet()) {
                    array.add((JsonElement)this.serializeResult(result));
                }
                object.add("results", (JsonElement)array);
            }
        }

        private JsonObject serializeResult(Map.Entry<Item, Integer> result) {
            JsonObject object = new JsonObject();
            object.addProperty("item", result.getKey().getRegistryName().toString());
            if (result.getValue() > 1) {
                object.addProperty("count", (Number)result.getValue());
            }
            return object;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipeTypes.CUTTING_SERIALIZER.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

