/*
 * Decompiled with CFR 0.152.
 */
package someasseblyrequired.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import someasseblyrequired.common.block.WaterLoggableHorizontalBlock;
import someasseblyrequired.common.block.tileentity.RedstoneToasterTileEntity;
import someasseblyrequired.common.init.TileEntityTypes;

public class RedstoneToasterBlock
extends WaterLoggableHorizontalBlock {
    public static final BooleanProperty TOASTING = BooleanProperty.func_177716_a((String)"toasting");
    private static final VoxelShape SHAPE_NORTH_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)1.0, (double)15.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)1.0, (double)2.0, (double)12.0, (double)10.0, (double)14.0));
    private static final VoxelShape SHAPE_EAST_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)1.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)10.0, (double)12.0));
    private final boolean isEjectionToaster;

    public RedstoneToasterBlock(AbstractBlock.Properties properties, boolean isEjectionToaster) {
        super(properties);
        this.isEjectionToaster = isEjectionToaster;
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)TOASTING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TOASTING, BlockStateProperties.field_208194_u});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)TOASTING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176746_e());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof RedstoneToasterTileEntity)) {
            return ActionResultType.PASS;
        }
        RedstoneToasterTileEntity toaster = (RedstoneToasterTileEntity)tileEntity;
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return toaster.startToasting(player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        if (!heldItem.func_190926_b() && toaster.addItem(player.func_184812_l_() ? heldItem.func_77946_l() : heldItem)) {
            return ActionResultType.SUCCESS;
        }
        return this.removeIngredient(toaster, world, pos, player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    private boolean removeIngredient(RedstoneToasterTileEntity toaster, World world, BlockPos pos, PlayerEntity player) {
        ItemStack ingredient = toaster.removeItem();
        if (!ingredient.func_190926_b()) {
            if (!player.func_184812_l_()) {
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.75, (double)pos.func_177952_p() + 0.5, ingredient);
                item.func_174867_a(5);
                world.func_217376_c((Entity)item);
            }
            return true;
        }
        return false;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof RedstoneToasterTileEntity) {
            ((RedstoneToasterTileEntity)tileEntity).startToasting();
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity tileEntity;
        boolean isPowered = world.func_175640_z(pos) || world.func_175640_z(pos.func_177984_a());
        boolean wasPowered = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
        if (isPowered && !wasPowered) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!isPowered && wasPowered) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)), 4);
        }
        if (((Boolean)world.func_180495_p(pos).func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && (tileEntity = world.func_175625_s(pos)) instanceof RedstoneToasterTileEntity && ((RedstoneToasterTileEntity)tileEntity).isToasting()) {
            ((RedstoneToasterTileEntity)tileEntity).explode();
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        RedstoneToasterTileEntity tileEntity = (RedstoneToasterTileEntity)TileEntityTypes.REDSTONE_TOASTER.func_200968_a();
        if (tileEntity != null) {
            tileEntity.setAutoEject(this.isEjectionToaster);
        }
        return tileEntity;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_176740_k() == Direction.Axis.X ? SHAPE_EAST_WEST : SHAPE_NORTH_SOUTH;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof RedstoneToasterTileEntity) {
            return 2 * ((RedstoneToasterTileEntity)tileEntity).getAmountOfItems() - 1;
        }
        return 0;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.func_203425_a(state.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof RedstoneToasterTileEntity) {
                NonNullList<ItemStack> items = ((RedstoneToasterTileEntity)tileEntity).removeItems();
                for (ItemStack stack : items) {
                    ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    world.func_217376_c((Entity)item);
                }
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }
}

