/*
 * Decompiled with CFR 0.152.
 */
package someasseblyrequired.common.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import someasseblyrequired.common.block.SandwichBlock;
import someasseblyrequired.common.block.tileentity.SandwichAssemblyTableTileEntity;
import someasseblyrequired.common.init.Items;
import someasseblyrequired.common.init.Tags;
import someasseblyrequired.common.init.TileEntityTypes;
import someasseblyrequired.common.item.spreadtype.SpreadType;
import someasseblyrequired.common.item.spreadtype.SpreadTypeManager;

public class SandwichAssemblyTableBlock
extends HorizontalBlock {
    public SandwichAssemblyTableBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityTypes.SANDWICH_ASSEMBLY_TABLE.func_200968_a();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof SandwichAssemblyTableTileEntity)) {
            return ActionResultType.PASS;
        }
        SandwichAssemblyTableTileEntity sandwichTable = (SandwichAssemblyTableTileEntity)tileEntity;
        if (player.func_225608_bj_()) {
            if (sandwichTable.getAmountOfItems() == 0) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.bottom_bread"), true);
                return ActionResultType.SUCCESS;
            } else if (!sandwichTable.hasBreadAsTopIngredient()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.top_bread"), true);
                return ActionResultType.SUCCESS;
            } else {
                ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, SandwichBlock.createSandwich(tileEntity));
                item.func_174867_a(5);
                world.func_217376_c((Entity)item);
                sandwichTable.removeItems();
            }
            return ActionResultType.SUCCESS;
        } else if (player.func_184586_b(Hand.OFF_HAND).func_190926_b() && player.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            ItemStack ingredient = sandwichTable.removeTopIngredient();
            if (player.func_184812_l_() || ingredient.func_190926_b()) return ActionResultType.SUCCESS;
            ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, ingredient);
            item.func_174867_a(5);
            world.func_217376_c((Entity)item);
            return ActionResultType.SUCCESS;
        } else {
            ItemStack heldItem = player.func_184586_b(hand);
            if (sandwichTable.addIngredient(heldItem)) {
                if (player.func_184812_l_()) return ActionResultType.SUCCESS;
                SpreadType spreadType = SpreadTypeManager.INSTANCE.getSpreadType(heldItem.func_77973_b());
                player.func_184586_b(hand).func_190918_g(1);
                if (spreadType == null || !spreadType.hasContainer(heldItem)) return ActionResultType.SUCCESS;
                ItemStack container = new ItemStack((IItemProvider)spreadType.getContainer(heldItem), 1);
                if (player.func_184586_b(hand).func_190926_b()) {
                    player.func_184611_a(hand, container);
                    return ActionResultType.SUCCESS;
                } else {
                    player.func_191521_c(container);
                }
                return ActionResultType.SUCCESS;
            } else {
                if (!heldItem.func_222117_E() && heldItem.func_77973_b() != Items.SPREAD && !SpreadTypeManager.INSTANCE.hasSpreadType(heldItem.func_77973_b())) return ActionResultType.FAIL;
                if (sandwichTable.getAmountOfItems() == 0 && !Tags.BREAD.func_230235_a_((Object)heldItem.func_77973_b())) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.bottom_bread"), true);
                    return ActionResultType.SUCCESS;
                } else {
                    if (sandwichTable.getAmountOfItems() != sandwichTable.getInventorySize()) return ActionResultType.FAIL;
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.someassemblyrequired.full_sandwich"), true);
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!newState.func_203425_a(state.func_177230_c())) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof SandwichAssemblyTableTileEntity) {
                for (ItemStack ingredient : ((SandwichAssemblyTableTileEntity)tileEntity).removeItems()) {
                    ItemEntity item = new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, ingredient);
                    world.func_217376_c((Entity)item);
                }
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
            for (int slot = 0; slot < handler.getSlots() && slot <= 15; ++slot) {
                if (!handler.getStackInSlot(slot).func_190926_b()) continue;
                return slot;
            }
            return 15;
        }
        return 0;
    }
}

