/*
 * Decompiled with CFR 0.152.
 */
package someasseblyrequired.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandlerTileEntity
extends TileEntity {
    private final TileEntityItemHandler inventory;
    private final LazyOptional<TileEntityItemHandler> itemHandler;
    private final boolean canModifyItems;

    public ItemHandlerTileEntity(TileEntityType<? extends ItemHandlerTileEntity> tileEntityType, int size) {
        this(tileEntityType, size, true);
    }

    public ItemHandlerTileEntity(TileEntityType<? extends ItemHandlerTileEntity> tileEntityType, int size, boolean canModifyItems) {
        super(tileEntityType);
        this.canModifyItems = canModifyItems;
        this.inventory = this.createItemHandler(size);
        this.itemHandler = LazyOptional.of(() -> this.inventory);
    }

    protected TileEntityItemHandler getInventory() {
        return this.inventory;
    }

    public NonNullList<ItemStack> getItems() {
        return this.inventory.getItems();
    }

    public NonNullList<ItemStack> removeItems() {
        return this.inventory.removeItems();
    }

    public int getAmountOfItems() {
        int size;
        for (size = 0; size < this.inventory.getSlots() && !this.inventory.getStackInSlot(size).func_190926_b(); ++size) {
        }
        return size;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    protected void onContentsUpdated() {
    }

    private void onContentsChanged() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
            this.func_70296_d();
        }
        this.onContentsUpdated();
    }

    private void onContentsLoaded() {
        this.onContentsUpdated();
    }

    public void func_230337_a_(BlockState state, CompoundNBT compoundNBT) {
        this.inventory.deserializeNBT(compoundNBT.func_74775_l("Ingredients"));
        super.func_230337_a_(state, compoundNBT);
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundNBT) {
        compoundNBT.func_218657_a("Ingredients", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(compoundNBT);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager networkManager, SUpdateTileEntityPacket packet) {
        if (this.field_145850_b != null) {
            this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), packet.func_148857_g());
        }
    }

    protected TileEntityItemHandler createItemHandler(int size) {
        return new TileEntityItemHandler(size);
    }

    protected boolean canModifyItems() {
        return this.canModifyItems;
    }

    protected class TileEntityItemHandler
    extends ItemStackHandler {
        protected TileEntityItemHandler(int size) {
            super(size);
        }

        public NonNullList<ItemStack> getItems() {
            NonNullList result = NonNullList.func_191196_a();
            for (int slot = 0; slot < ItemHandlerTileEntity.this.inventory.getSlots(); ++slot) {
                ItemStack stack = ItemHandlerTileEntity.this.inventory.getStackInSlot(slot);
                if (stack.func_190926_b()) continue;
                result.add((Object)stack);
            }
            return result;
        }

        public NonNullList<ItemStack> removeItems() {
            NonNullList<ItemStack> result = this.getItems();
            for (int slot = 0; slot < ItemHandlerTileEntity.this.inventory.getSlots(); ++slot) {
                this.setStackInSlot(slot, ItemStack.field_190927_a);
            }
            return result;
        }

        protected void onContentsChanged(int slot) {
            ItemHandlerTileEntity.this.onContentsChanged();
        }

        protected void onLoad() {
            ItemHandlerTileEntity.this.onContentsLoaded();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return ItemHandlerTileEntity.this.canModifyItems();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemHandlerTileEntity.this.canModifyItems() ? super.extractItem(slot, amount, simulate) : ItemStack.field_190927_a;
        }
    }
}

