/*
 * Decompiled with CFR 0.152.
 */
package someasseblyrequired.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import someasseblyrequired.common.init.Tags;

public class SandwichItem
extends BlockItem {
    public SandwichItem(Block block, Item.Properties builder) {
        super(block, builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            int size;
            for (size = 0; size < handler.getSlots() && !handler.getStackInSlot(size).func_190926_b(); ++size) {
            }
            for (int slot = size - 1; slot >= 0; --slot) {
                if (slot < size - 8 && size >= 10) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.someassemblyrequired.sandwich.tooltip.truncate_info", new Object[]{size - 8}).func_240699_a_(TextFormatting.GRAY).func_240699_a_(TextFormatting.ITALIC));
                    return;
                }
                tooltip.add((ITextComponent)handler.getStackInSlot(slot).func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GRAY));
            }
        });
    }

    protected boolean func_195941_b(BlockItemUseContext context, BlockState state) {
        if (context.func_195999_j() != null && context.func_195999_j().func_225608_bj_()) {
            return super.func_195941_b(context, state);
        }
        return false;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(handler -> {
            for (int slot = 0; slot < handler.getSlots() && !handler.getStackInSlot(slot).func_190926_b(); ++slot) {
                ItemStack ingredient = handler.getStackInSlot(slot);
                ItemStack finishStack = ingredient.func_77973_b().func_77654_b(ingredient, world, entity);
                if (!(entity instanceof PlayerEntity)) continue;
                PlayerEntity player = (PlayerEntity)entity;
                if (player.func_184811_cZ().func_185141_a(ingredient.func_77973_b())) {
                    player.func_184811_cZ().func_185145_a((Item)this, 20);
                }
                if (player.func_184812_l_() || finishStack.func_190926_b()) continue;
                player.func_191521_c(finishStack);
            }
        });
        return super.func_77654_b(stack, world, entity);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse((Object)EmptyHandler.INSTANCE);
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int slot = 0; slot < handler.getSlots() && !handler.getStackInSlot(slot).func_190926_b(); ++slot) {
            ingredients.add(handler.getStackInSlot(slot));
        }
        if (ingredients.size() >= 3) {
            ItemStack ingredient = (ItemStack)ingredients.get(1);
            if (ingredients.size() % 2 != 0 && ingredients.stream().allMatch(sandwichComponent -> ingredients.indexOf(sandwichComponent) % 2 == 0 ? Tags.BREAD.func_230235_a_((Object)sandwichComponent.func_77973_b()) : ItemStack.func_77989_b((ItemStack)ingredient, (ItemStack)sandwichComponent)) && (ingredient.func_77973_b() == someasseblyrequired.common.init.Items.TOASTED_BREAD_SLICE || !Tags.BREAD.func_230235_a_((Object)ingredient.func_77973_b()))) {
                ItemStack spreadItem;
                if (ingredient.func_77978_p() != null && ingredient.func_77978_p().func_74764_b("Ingredient") && (spreadItem = ItemStack.func_199557_a((CompoundNBT)ingredient.func_190925_c("Ingredient"))).func_77973_b() == Items.field_151068_bn) {
                    Potion potion = PotionUtils.func_185191_c((ItemStack)spreadItem);
                    if (potion == Potions.field_185230_b && ingredients.size() == 3) {
                        return new TranslationTextComponent("item.someassemblyrequired.soggy_sandwich");
                    }
                    if (potion.func_185170_a().size() == 1) {
                        return new TranslationTextComponent("item.someassemblyrequired." + this.getQuantifier(ingredients.size() / 2) + "_potion_sandwich", new Object[]{((EffectInstance)potion.func_185170_a().get(0)).func_188419_a().func_199286_c()});
                    }
                }
                return new TranslationTextComponent("item.someassemblyrequired." + this.getQuantifier(ingredients.size() / 2) + "_sandwich", new Object[]{this.getIngredientDisplayName(ingredient)});
            }
        }
        int breadAmount = 0;
        for (ItemStack ingredient : ingredients) {
            if (!Tags.BREAD.func_230235_a_((Object)ingredient.func_77973_b())) continue;
            ++breadAmount;
        }
        if (breadAmount == ingredients.size()) {
            return new TranslationTextComponent("item.someassemblyrequired.snadwich");
        }
        if (breadAmount == 3) {
            return new TranslationTextComponent("item.someassemblyrequired.double_decker_sandwich");
        }
        return super.func_200295_i(stack);
    }

    private String getQuantifier(int number) {
        switch (number) {
            case 1: {
                return "single";
            }
            case 2: {
                return "double";
            }
            case 3: {
                return "triple";
            }
            case 4: {
                return "quadruple";
            }
            case 5: {
                return "quintuple";
            }
            case 6: {
                return "sextuple";
            }
            case 7: {
                return "septuple";
            }
        }
        return "very_large";
    }

    private ITextComponent getIngredientDisplayName(ItemStack ingredient) {
        if (ingredient.func_77973_b() == someasseblyrequired.common.init.Items.TOASTED_BREAD_SLICE) {
            return new TranslationTextComponent("item.someassemblyrequired.sandwich.toast");
        }
        return ingredient.func_200301_q();
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundNBT compoundNBT) {
        return new ICapabilityProvider(){
            private final LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);

            private IItemHandler createHandler() {
                IngredientItemHandler handler = new IngredientItemHandler(stack);
                handler.deserializeNBT(stack.func_190925_c("BlockEntityTag").func_74775_l("Ingredients"));
                return handler;
            }

            public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.handler.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    private static class IngredientItemHandler
    extends ItemStackHandler {
        private final ItemStack sandwichItem;

        private IngredientItemHandler(ItemStack sandwichItem) {
            super(0);
            this.sandwichItem = sandwichItem;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        protected void onContentsChanged(int slot) {
            this.sandwichItem.func_190925_c("BlockEntityTag").func_218657_a("Ingredients", (INBT)this.serializeNBT());
        }
    }
}

