/*
 * Decompiled with CFR 0.152.
 */
package someasseblyrequired.common.network;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import someasseblyrequired.common.item.spreadtype.SimpleSpreadType;
import someasseblyrequired.common.item.spreadtype.SpreadTypeManager;

public class SpreadTypeSyncPacket {
    private final Map<ResourceLocation, SimpleSpreadType> spreadTypes;

    public SpreadTypeSyncPacket(Map<ResourceLocation, SimpleSpreadType> spreadTypes) {
        this.spreadTypes = spreadTypes;
    }

    public SpreadTypeSyncPacket(PacketBuffer buffer) {
        int size = buffer.func_150792_a();
        this.spreadTypes = new HashMap<ResourceLocation, SimpleSpreadType>(size);
        for (int i = 0; i < size; ++i) {
            ResourceLocation resourceLocation = buffer.func_192575_l();
            SimpleSpreadType simpleSpreadType = SimpleSpreadType.read(buffer);
            this.spreadTypes.put(resourceLocation, simpleSpreadType);
        }
    }

    void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.spreadTypes.size());
        this.spreadTypes.forEach((resourceLocation, simpleSpreadType) -> {
            buffer.func_192572_a(resourceLocation);
            simpleSpreadType.write(buffer);
        });
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SpreadTypeManager.INSTANCE.setSpreadTypes(this.spreadTypes));
        context.get().setPacketHandled(true);
    }
}

