/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHolder {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    protected static CommonConfig COMMON;
    protected static ClientConfig CLIENT;

    static {
        Pair CommonSpecPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)CommonSpecPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)CommonSpecPair.getRight();
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT = (ClientConfig)clientSpecPair.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
    }

    protected static final class CommonConfig {
        protected final ForgeConfigSpec.ConfigValue<Double> fatigueRate;
        protected final ForgeConfigSpec.ConfigValue<Double> fatigueReplenishRate;
        protected final ForgeConfigSpec.BooleanValue fatigueSideEffects;
        protected final ForgeConfigSpec.ConfigValue<Integer> minimumFatigueToSleep;
        protected final ForgeConfigSpec.ConfigValue<List<? extends List<Integer>>> sideEffectStages;
        protected final ForgeConfigSpec.ConfigValue<List<? extends List<Object>>> replenishingItems;
        protected final ForgeConfigSpec.ConfigValue<Double> delta;
        protected final ForgeConfigSpec.ConfigValue<Double> baseMultiplier;
        protected final ForgeConfigSpec.ConfigValue<Double> multiplierCap;
        protected final ForgeConfigSpec.BooleanValue fading;
        protected final ForgeConfigSpec.BooleanValue ignoreMonsters;
        protected final ForgeConfigSpec.BooleanValue muteSoundWhenSleeping;
        protected final ForgeConfigSpec.BooleanValue sleepWithArmor;
        protected final ForgeConfigSpec.ConfigValue<String> wakeTimeSelectItem;
        protected final ForgeConfigSpec.BooleanValue disableCreatureSpawning;
        protected final ForgeConfigSpec.ConfigValue<Integer> enterSleepStart;
        protected final ForgeConfigSpec.ConfigValue<Integer> enterSleepEnd;
        protected final ForgeConfigSpec.ConfigValue<Integer> validSleepStart;
        protected final ForgeConfigSpec.ConfigValue<Integer> validSleepEnd;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("fatigue");
            this.fatigueRate = builder.comment("Fatigue is incremented by this number every tick").define("fatigueRate", (Object)0.00208);
            this.fatigueReplenishRate = builder.comment("Fatigue is decreased by this number while you sleep (every tick)").define("fatigueReplenishRate", (Object)0.00833);
            this.fatigueSideEffects = builder.comment("Enables fatigue side effects").define("fatigueSideEffects", true);
            this.minimumFatigueToSleep = builder.comment("The required amount of fatigue to sleep").define("minimumFatigueToSleep", (Object)20);
            this.sideEffectStages = builder.comment("Definitions of each side effect stage in order: min fatigue, max fatigue, potion ID, duration, amplifier. For a permanent effect, set the duration to -1.").defineList("sideEffectStages", Arrays.asList(Arrays.asList(70, 80, 9, 150, 0), Arrays.asList(80, 90, 2, 300, 2), Arrays.asList(90, 95, 19, 200, 1), Arrays.asList(95, 100, 2, -1, 3)), obj -> obj instanceof List);
            this.replenishingItems = builder.comment("Definitions of fatigue replenishing items. Each list consist of an item registry name, the amount of fatigue it replenishes, and optionally a fatigue rate modifier").defineList("replenishingItems", Arrays.asList(Arrays.asList("coffeespawner:coffee", 10), Arrays.asList("coffeespawner:coffee_milk", 10), Arrays.asList("coffeespawner:coffee_sugar", 15), Arrays.asList("coffeespawner:coffee_milk_sugar", 15), Arrays.asList("coffeemod:coffee", 15), Arrays.asList("coffeemod:espresso", 15), Arrays.asList("coffeemod:latte", 15), Arrays.asList("coffeemod:caramel_macchiato", 10), Arrays.asList("coffeemod:mocha", 10), Arrays.asList("coffeemod:frappe", 10)), obj -> obj instanceof List);
            builder.pop();
            builder.push("logic");
            this.delta = builder.comment("If the time difference (mc) between multiplied ticking is greater than this, the simulation multiplier is lowered. Otherwise, it's increased. Lowering this number might slow down simulation and improve performance. Don't mess around with it if you don't know what you're doing.").defineInRange("delta", 50.0, 1.0, 50.0);
            this.baseMultiplier = builder.comment("Minimum tick speed multiplier, activated during sleep").define("baseMultiplier", (Object)1.0);
            this.multiplierCap = builder.comment("Maximum tick speed multiplier, activated during sleep").define("multiplierCap", (Object)100.0);
            builder.pop();
            builder.push("options");
            this.fading = builder.comment("Slightly slower sleep start/end").define("fading", true);
            this.ignoreMonsters = builder.comment("Let the player sleep even when there are monsters nearby").define("ignoreMonsters", false);
            this.muteSoundWhenSleeping = builder.comment("Deafens you while you're asleep. Mob sounds are confusing with the world sped up").define("muteSoundWhenSleeping", false);
            this.sleepWithArmor = builder.comment("Allows you to sleep with armor equipped").define("sleepWithArmor", false);
            this.wakeTimeSelectItem = builder.comment("the item used to select wake time").define("wakeTimeSelectItem", (Object)"minecraft:clock");
            builder.pop();
            builder.push("performance");
            this.disableCreatureSpawning = builder.comment("Disables mob spawning while you sleep").define("disableCreatureSpawning", false);
            builder.pop();
            builder.push("timings");
            this.enterSleepStart = builder.comment("Specifies the start of the period in which the player can enter sleep").defineInRange("enterSleepStart", 0, 0, 24000);
            this.enterSleepEnd = builder.comment("Specifies the end of the period in which the player can enter sleep").defineInRange("enterSleepEnd", 24000, 0, 24000);
            this.validSleepStart = builder.comment("Specifies the start of the valid sleep period").defineInRange("validSleepStart", 0, 0, 24000);
            this.validSleepEnd = builder.comment("Specifies the end of the valid sleep period").defineInRange("validSleepEnd", 24000, 0, 24000);
            builder.pop();
        }
    }

    protected static final class ClientConfig {
        protected final ForgeConfigSpec.ConfigValue<String> displayFatigue;
        protected final ForgeConfigSpec.BooleanValue simpleFatigueDisplay;
        protected final ForgeConfigSpec.ConfigValue<String> displayETASleep;
        protected final ForgeConfigSpec.BooleanValue somniaGui;
        protected final ForgeConfigSpec.ConfigValue<String> somniaGuiClockPosition;
        protected final ForgeConfigSpec.BooleanValue disableRendering;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("fatigue");
            this.displayFatigue = builder.comment("The fatigue counter's position. Accepted values: TOP_CENTER, TOP_LEFT, TOP_RIGHT, BOTTOM_CENTER, BOTTOM_LEFT, BOTTOM_RIGHT").define("displayFatigue", (Object)"BOTTOM_RIGHT");
            this.simpleFatigueDisplay = builder.comment("Simplifies the numerical fatigue counter to words").define("simpleFatigueDisplay", false);
            this.displayETASleep = builder.comment("The ETA and multiplier display position in Somnia's sleep gui. Accepted values: right, center, left").define("displayETASleep", (Object)"left");
            builder.pop();
            builder.push("options");
            this.somniaGui = builder.comment("Provides an enhanced sleeping gui").define("somniaGui", true);
            this.somniaGuiClockPosition = builder.comment("The display position of the clock in somnia's enhanced sleeping gui. Accepted values: right, center, left").define("somniaGuiClockPosition", (Object)"right");
            builder.pop();
            builder.push("performance");
            this.disableRendering = builder.comment("Disable rendering while you're asleep").define("disableRendering", false);
            builder.pop();
        }
    }
}

