/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.config;

import java.util.List;
import java.util.stream.Collectors;
import mods.su5ed.somnia.config.ConfigHolder;
import mods.su5ed.somnia.config.SomniaConfig;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Triple;

@Mod.EventBusSubscriber(modid="somnia", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigSetup {
    @SubscribeEvent
    public static void onModConfig(ModConfig.ModConfigEvent event) {
        ForgeConfigSpec spec = event.getConfig().getSpec();
        if (spec == ConfigHolder.COMMON_SPEC) {
            ConfigSetup.updateCommonConfig();
        } else if (spec == ConfigHolder.CLIENT_SPEC) {
            ConfigSetup.updateClientConfig();
        }
    }

    private static void updateClientConfig() {
        SomniaConfig.displayFatigue = (String)ConfigHolder.CLIENT.displayFatigue.get();
        SomniaConfig.simpleFatigueDisplay = (Boolean)ConfigHolder.CLIENT.simpleFatigueDisplay.get();
        SomniaConfig.displayETASleep = (String)ConfigHolder.CLIENT.displayETASleep.get();
        SomniaConfig.somniaGui = (Boolean)ConfigHolder.CLIENT.somniaGui.get();
        SomniaConfig.somniaGuiClockPosition = (String)ConfigHolder.CLIENT.somniaGuiClockPosition.get();
        SomniaConfig.disableRendering = (Boolean)ConfigHolder.CLIENT.disableRendering.get();
    }

    private static void updateCommonConfig() {
        SomniaConfig.fatigueRate = (Double)ConfigHolder.COMMON.fatigueRate.get();
        SomniaConfig.fatigueReplenishRate = (Double)ConfigHolder.COMMON.fatigueReplenishRate.get();
        SomniaConfig.fatigueSideEffects = (Boolean)ConfigHolder.COMMON.fatigueSideEffects.get();
        SomniaConfig.minimumFatigueToSleep = ((Integer)ConfigHolder.COMMON.minimumFatigueToSleep.get()).intValue();
        SomniaConfig.sideEffectStages = (List)ConfigHolder.COMMON.sideEffectStages.get();
        SomniaConfig.replenishingItems = ((List)ConfigHolder.COMMON.replenishingItems.get()).stream().map(list -> Triple.of((Object)ConfigSetup.getModItem((String)list.get(0)), (Object)Double.parseDouble(list.get(1).toString()), (Object)(list.size() > 2 ? Double.parseDouble(list.get(2).toString()) : SomniaConfig.fatigueRate))).filter(triple -> triple.getLeft() != null).collect(Collectors.toList());
        SomniaConfig.delta = (Double)ConfigHolder.COMMON.delta.get();
        SomniaConfig.baseMultiplier = (Double)ConfigHolder.COMMON.baseMultiplier.get();
        SomniaConfig.multiplierCap = (Double)ConfigHolder.COMMON.multiplierCap.get();
        SomniaConfig.fading = (Boolean)ConfigHolder.COMMON.fading.get();
        SomniaConfig.ignoreMonsters = (Boolean)ConfigHolder.COMMON.ignoreMonsters.get();
        SomniaConfig.muteSoundWhenSleeping = (Boolean)ConfigHolder.COMMON.muteSoundWhenSleeping.get();
        SomniaConfig.sleepWithArmor = (Boolean)ConfigHolder.COMMON.sleepWithArmor.get();
        SomniaConfig.wakeTimeSelectItem = (String)ConfigHolder.COMMON.wakeTimeSelectItem.get();
        SomniaConfig.disableCreatureSpawning = (Boolean)ConfigHolder.COMMON.disableCreatureSpawning.get();
        SomniaConfig.enterSleepStart = (Integer)ConfigHolder.COMMON.enterSleepStart.get();
        SomniaConfig.enterSleepEnd = (Integer)ConfigHolder.COMMON.enterSleepEnd.get();
        SomniaConfig.validSleepStart = (Integer)ConfigHolder.COMMON.validSleepStart.get();
        SomniaConfig.validSleepEnd = (Integer)ConfigHolder.COMMON.validSleepEnd.get();
    }

    private static Item getModItem(String registryName) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
    }
}

