/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketUpdateFatigue;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SomniaCommand {
    public static final Set<UUID> OVERRIDES = new HashSet<UUID>();

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"somnia").requires(src -> src.func_197034_c(3))).then(Commands.func_197057_a((String)"fatigue").then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> SomniaCommand.setFatigue(DoubleArgumentType.getDouble((CommandContext)ctx, (String)"amount"), ((CommandSource)ctx.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> SomniaCommand.setFatigue(DoubleArgumentType.getDouble((CommandContext)ctx, (String)"amount"), EntityArgument.func_197089_d((CommandContext)ctx, (String)"target")))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"override").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> SomniaCommand.addOverride(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target")))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> SomniaCommand.removeOverride(EntityArgument.func_197089_d((CommandContext)ctx, (String)"target")))))).then(Commands.func_197057_a((String)"list").executes(SomniaCommand::listOverrides))));
    }

    private static int setFatigue(double amount, ServerPlayerEntity player) {
        player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
            props.setFatigue(amount);
            NetworkHandler.sendToClient(new PacketUpdateFatigue(props.getFatigue()), player);
        });
        return 1;
    }

    private static int addOverride(ServerPlayerEntity player) {
        if (!OVERRIDES.add(player.func_110124_au())) {
            player.func_146105_b((ITextComponent)new StringTextComponent("Override already exists"), true);
        }
        return 1;
    }

    private static int removeOverride(ServerPlayerEntity target) {
        OVERRIDES.remove(target.func_110124_au());
        return 1;
    }

    private static int listOverrides(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        ServerPlayerEntity sender = ((CommandSource)ctx.getSource()).func_197035_h();
        List overrides = OVERRIDES.stream().map(arg_0 -> ((World)sender.field_70170_p).func_217371_b(arg_0)).filter(Objects::nonNull).map(player -> player.func_200200_C_().func_150261_e()).collect(Collectors.toList());
        StringTextComponent chatComponent = new StringTextComponent(!overrides.isEmpty() ? String.join((CharSequence)", ", overrides) : "Nothing to see here...");
        sender.func_146105_b((ITextComponent)chatComponent, false);
        return 1;
    }
}

