/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.api.capability.IFatigue;
import mods.su5ed.somnia.config.SomniaConfig;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketUpdateWakeTime;
import mods.su5ed.somnia.network.packet.PacketWakeUpPlayer;
import mods.su5ed.somnia.util.SideEffectStage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class ClientTickHandler {
    public static final ClientTickHandler INSTANCE = new ClientTickHandler();
    public static final DecimalFormat MULTIPLIER_FORMAT = new DecimalFormat("0.0");
    private static final ItemStack CLOCK = new ItemStack((IItemProvider)Items.field_151113_aN);
    private final Minecraft mc = Minecraft.func_71410_x();
    private final List<Double> speedValues = new ArrayList<Double>();
    public long sleepStart = -1L;
    public double speed;
    private boolean muted;
    private float volume;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null) {
                if (mc.field_71439_g.func_70608_bn() && SomniaConfig.muteSoundWhenSleeping && !this.muted) {
                    this.muted = true;
                    this.volume = mc.field_71474_y.func_186711_a(SoundCategory.MASTER);
                    mc.field_71474_y.func_186712_a(SoundCategory.MASTER, 0.0f);
                } else if (this.muted) {
                    this.muted = false;
                    mc.field_71474_y.func_186712_a(SoundCategory.MASTER, this.volume);
                }
                mc.field_71439_g.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).filter(props -> {
                    long wakeTime = props.getWakeTime();
                    return wakeTime > -1L && mc.field_71441_e.func_82737_E() >= wakeTime;
                }).ifPresent(props -> {
                    NetworkHandler.INSTANCE.sendToServer((Object)new PacketUpdateWakeTime(-1L));
                    props.setWakeTime(-1L);
                    mc.field_71439_g.func_213366_dy();
                    NetworkHandler.INSTANCE.sendToServer((Object)new PacketWakeUpPlayer());
                });
            }
        }
    }

    public void addSpeedValue(double speed) {
        this.speed = speed;
        this.speedValues.add(speed);
        if (this.speedValues.size() > 5) {
            this.speedValues.remove(0);
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!(this.mc.field_71462_r == null || this.mc.field_71462_r instanceof IngameMenuScreen || this.mc.field_71439_g != null && this.mc.field_71439_g.func_70608_bn())) {
            return;
        }
        double fatigue = this.mc.field_71439_g.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).resolve().map(IFatigue::getFatigue).orElse(0.0);
        MatrixStack matrixStack = new MatrixStack();
        if (!(event.phase != TickEvent.Phase.END || this.mc.field_71439_g.func_184812_l_() || this.mc.field_71439_g.func_175149_v() || this.mc.field_71474_y.field_74319_N)) {
            if (!this.mc.field_71439_g.func_70608_bn() && !SomniaConfig.fatigueSideEffects && fatigue > SomniaConfig.minimumFatigueToSleep) {
                return;
            }
            String str = SomniaConfig.simpleFatigueDisplay ? SpeedColor.WHITE.code + SideEffectStage.getSideEffectStageDescription(fatigue) : String.format(SpeedColor.WHITE.code + "Fatigue: %.2f", fatigue);
            int width = this.mc.field_71466_p.func_78256_a(str);
            int scaledWidth = this.mc.func_228018_at_().func_198107_o();
            int scaledHeight = this.mc.func_228018_at_().func_198087_p();
            FatigueDisplayPosition pos = this.mc.field_71439_g.func_70608_bn() ? FatigueDisplayPosition.BOTTOM_RIGHT : FatigueDisplayPosition.valueOf(SomniaConfig.displayFatigue);
            FontRenderer fontRenderer = this.mc.field_71466_p;
            float f = pos.getX(scaledWidth, width);
            this.mc.field_71466_p.getClass();
            fontRenderer.func_238421_b_(matrixStack, str, f, (float)pos.getY(scaledHeight, 9), Integer.MIN_VALUE);
        }
        if (this.mc.field_71439_g.func_70608_bn() && SomniaConfig.somniaGui && fatigue != -1.0) {
            this.renderSleepGui(matrixStack, this.mc.field_71462_r);
        } else if (this.sleepStart != -1L || this.speed != 0.0) {
            this.sleepStart = -1L;
            this.speed = 0.0;
        }
    }

    private void renderSleepGui(MatrixStack matrixStack, Screen screen) {
        if (screen == null) {
            return;
        }
        if (this.speed != 0.0) {
            if (this.sleepStart == -1L) {
                this.sleepStart = this.mc.field_71441_e.func_82737_E();
            }
        } else {
            this.sleepStart = -1L;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2912);
        this.mc.field_71439_g.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).map(IFatigue::getWakeTime).filter(wakeTime -> wakeTime > -1L).ifPresent(wakeTime -> {
            if (this.sleepStart != -1L) {
                this.mc.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
                double sleepDuration = this.mc.field_71441_e.func_82737_E() - this.sleepStart;
                double remaining = wakeTime - this.sleepStart;
                double progress = sleepDuration / remaining;
                int width = screen.field_230708_k_ - 40;
                GL11.glEnable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                this.renderProgressBar(matrixStack, width, 1.0);
                GL11.glDisable((int)3042);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.renderProgressBar(matrixStack, width, progress);
                int offsetX = SomniaConfig.displayETASleep.equals("center") ? screen.field_230708_k_ / 2 - 80 : (SomniaConfig.displayETASleep.equals("right") ? width - 160 : 0);
                this.renderScaledString(matrixStack, offsetX + 20, String.format("%sx%s", SpeedColor.getColorForSpeed((double)this.speed).code, MULTIPLIER_FORMAT.format(this.speed)));
                double average = this.speedValues.stream().filter(Objects::nonNull).mapToDouble(Double::doubleValue).summaryStatistics().getAverage();
                long eta = Math.round((remaining - sleepDuration) / (average * 20.0));
                this.renderScaledString(matrixStack, offsetX + 80, this.getETAString(eta));
                this.renderClock(width);
            }
        });
    }

    private String getETAString(long totalSeconds) {
        long etaSeconds = totalSeconds % 60L;
        long etaMinutes = (totalSeconds - etaSeconds) / 60L;
        return String.format(SpeedColor.WHITE.code + "(%s:%s)", (etaMinutes < 10L ? "0" : "") + etaMinutes, (etaSeconds < 10L ? "0" : "") + etaSeconds);
    }

    private void renderProgressBar(MatrixStack matrixStack, int width, double progress) {
        int x = 20;
        int amount = (int)(progress * (double)width);
        while (amount > 0) {
            if (this.mc.field_71462_r != null) {
                this.mc.field_71462_r.func_238474_b_(matrixStack, x, 10, 0, 69, Math.min(amount, 180), 5);
            }
            amount -= 180;
            x += 180;
        }
    }

    private void renderScaledString(MatrixStack matrixStack, int x, String str) {
        if (this.mc.field_71462_r == null) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)20.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0f);
        this.mc.field_71466_p.func_238405_a_(matrixStack, str, 0.0f, 0.0f, Integer.MIN_VALUE);
        GL11.glPopMatrix();
    }

    private void renderClock(int maxWidth) {
        int x;
        switch (SomniaConfig.somniaGuiClockPosition) {
            case "left": {
                x = 40;
                break;
            }
            case "center": {
                x = maxWidth / 2;
                break;
            }
            default: {
                x = maxWidth - 40;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)35.0f, (float)0.0f);
        GL11.glScalef((float)4.0f, (float)4.0f, (float)1.0f);
        this.mc.func_175599_af().func_184391_a((LivingEntity)this.mc.field_71439_g, CLOCK, 0, 0);
        GL11.glPopMatrix();
    }

    static {
        CompoundNBT clockNbt = new CompoundNBT();
        clockNbt.func_74757_a("quark:clock_calculated", true);
        CLOCK.func_77982_d(clockNbt);
    }

    public static enum FatigueDisplayPosition {
        TOP_CENTER((scaledWidth, stringWidth) -> scaledWidth / 2 - stringWidth / 2, (scaledHeight, fontHeight) -> fontHeight),
        TOP_LEFT((scaledWidth, stringWidth) -> 10, (scaledHeight, fontHeight) -> fontHeight),
        TOP_RIGHT((scaledWidth, stringWidth) -> scaledWidth - stringWidth - 10, (scaledHeight, fontHeight) -> fontHeight),
        BOTTOM_CENTER((scaledWidth, stringWidth) -> scaledWidth / 2 - stringWidth / 2, (scaledHeight, fontHeight) -> scaledHeight - fontHeight - 45),
        BOTTOM_LEFT((scaledWidth, stringWidth) -> 10, (scaledHeight, fontHeight) -> scaledHeight - fontHeight - 10),
        BOTTOM_RIGHT((scaledWidth, stringWidth) -> scaledWidth - stringWidth - 10, (scaledHeight, fontHeight) -> scaledHeight - fontHeight - 10);

        private final BiFunction<Integer, Integer, Integer> x;
        private final BiFunction<Integer, Integer, Integer> y;

        private FatigueDisplayPosition(BiFunction<Integer, Integer, Integer> x, BiFunction<Integer, Integer, Integer> y) {
            this.x = x;
            this.y = y;
        }

        public int getX(int scaledWidth, int stringWidth) {
            return this.x.apply(scaledWidth, stringWidth);
        }

        public int getY(int scaledHeight, int fontHeight) {
            return this.y.apply(scaledHeight, fontHeight);
        }
    }

    public static enum SpeedColor {
        WHITE("\u00a7f", 8.0),
        DARK_RED("\u00a74", 20.0),
        RED("\u00a7c", 30.0),
        GOLD("\u00a76", 100.0);

        public static final Set<SpeedColor> VALUES;
        public static final char COLOR = '\u00a7';
        public final String code;
        public final double range;

        private SpeedColor(String code, double range) {
            this.code = code;
            this.range = range;
        }

        public static SpeedColor getColorForSpeed(double speed) {
            for (SpeedColor color : VALUES) {
                if (!(speed < color.range)) continue;
                return color;
            }
            return WHITE;
        }

        static {
            VALUES = Arrays.stream(SpeedColor.values()).sorted(Comparator.comparing(color -> color.range)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
    }
}

