/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.handler;

import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import mods.su5ed.somnia.api.SomniaAPI;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.api.capability.IFatigue;
import mods.su5ed.somnia.compat.Compat;
import mods.su5ed.somnia.compat.DarkUtilsPlugin;
import mods.su5ed.somnia.config.SomniaConfig;
import mods.su5ed.somnia.core.Somnia;
import mods.su5ed.somnia.core.SomniaObjects;
import mods.su5ed.somnia.handler.ServerTickHandler;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketOpenGUI;
import mods.su5ed.somnia.network.packet.PacketUpdateFatigue;
import mods.su5ed.somnia.network.packet.PacketWakeUpPlayer;
import mods.su5ed.somnia.util.ASMHooks;
import mods.su5ed.somnia.util.SideEffectStage;
import mods.su5ed.somnia.util.SomniaUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeEventHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.player.field_70170_p.field_72995_K || !event.player.func_70089_S() || event.player.func_184812_l_() || event.player.func_175149_v() && !event.player.func_70608_bn()) {
            return;
        }
        event.player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
            boolean isSleeping;
            double fatigue = props.getFatigue();
            double extraFatigueRate = props.getExtraFatigueRate();
            double replenishedFatigue = props.getReplenishedFatigue();
            boolean bl = isSleeping = props.sleepOverride() || event.player.func_70608_bn();
            if (isSleeping) {
                fatigue -= SomniaConfig.fatigueReplenishRate;
                double share = SomniaConfig.fatigueReplenishRate / SomniaConfig.fatigueRate;
                double replenish = SomniaConfig.fatigueReplenishRate * share;
                extraFatigueRate -= SomniaConfig.fatigueReplenishRate / share / replenishedFatigue / 10.0;
                replenishedFatigue -= replenish;
            } else {
                SideEffectStage[] insomnia;
                double rate = SomniaConfig.fatigueRate;
                EffectInstance wakefulness = event.player.func_70660_b((Effect)SomniaObjects.AWAKENING_EFFECT.get());
                if (wakefulness != null) {
                    rate -= wakefulness.func_76458_c() == 0 ? rate / 4.0 : rate / 3.0;
                }
                if ((insomnia = event.player.func_70660_b((Effect)SomniaObjects.INSOMNIA_EFFECT.get())) != null) {
                    rate += insomnia.func_76458_c() == 0 ? rate / 2.0 : rate;
                }
                fatigue += rate + props.getExtraFatigueRate();
            }
            if (fatigue > 100.0) {
                fatigue = 100.0;
            } else if (fatigue < 0.0) {
                fatigue = 0.0;
            }
            if (replenishedFatigue > 100.0) {
                replenishedFatigue = 100.0;
            } else if (replenishedFatigue < 0.0) {
                replenishedFatigue = 0.0;
            }
            if (extraFatigueRate < 0.0) {
                extraFatigueRate = 0.0;
            }
            props.setFatigue(fatigue);
            props.setReplenishedFatigue(replenishedFatigue);
            props.setExtraFatigueRate(extraFatigueRate);
            if (props.updateFatigueCounter() >= 100) {
                props.resetFatigueCounter();
                NetworkHandler.sendToClient(new PacketUpdateFatigue(fatigue), (ServerPlayerEntity)event.player);
                if (SomniaConfig.fatigueSideEffects) {
                    int lastSideEffectStage = props.getSideEffectStage();
                    SideEffectStage[] stages = SideEffectStage.getSideEffectStages();
                    SideEffectStage firstStage = stages[0];
                    if (fatigue < (double)firstStage.minFatigue) {
                        props.setSideEffectStage(-1);
                        for (SideEffectStage stage : stages) {
                            Effect effect = Effect.func_188412_a((int)stage.potionID);
                            if (lastSideEffectStage >= stage.minFatigue || !event.player.func_70644_a(effect)) continue;
                            event.player.func_195063_d(effect);
                        }
                    }
                    for (int i = 0; i < SomniaConfig.sideEffectStages.size(); ++i) {
                        boolean permanent;
                        SideEffectStage stage = stages[i];
                        boolean bl2 = permanent = stage.duration < 0;
                        if (!(fatigue >= (double)stage.minFatigue) || !(fatigue <= (double)stage.maxFatigue) || !permanent && lastSideEffectStage >= stage.minFatigue) continue;
                        if (!permanent) {
                            props.setSideEffectStage(stage.minFatigue);
                        }
                        event.player.func_195064_c(new EffectInstance(Effect.func_188412_a((int)stage.potionID), permanent ? 150 : stage.duration, stage.amplifier));
                    }
                }
            }
        });
    }

    @SubscribeEvent
    public static void onTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ServerTickHandler.HANDLERS.forEach(ServerTickHandler::tickEnd);
        }
    }

    @SubscribeEvent
    public static void onWakeUp(PlayerWakeUpEvent event) {
        PlayerEntity player = event.getPlayer();
        player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
            if (props.shouldSleepNormally() || ModList.get().isLoaded("darkutils") && DarkUtilsPlugin.hasSleepCharm(player)) {
                props.setFatigue(props.getFatigue() - SomniaUtil.getFatigueToReplenish(player));
            }
            props.maxFatigueCounter();
            props.shouldResetSpawn(true);
            props.setSleepNormally(false);
            props.setWakeTime(-1L);
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSleepingTimeCheck(SleepingTimeCheckEvent event) {
        PlayerEntity player = event.getPlayer();
        if (ModList.get().isLoaded("darkutils") && DarkUtilsPlugin.hasSleepCharm(player)) {
            return;
        }
        Optional props = player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).resolve();
        if (props.isPresent() && ((IFatigue)props.get()).shouldSleepNormally()) {
            return;
        }
        if (!SomniaUtil.isEnterSleepTime()) {
            event.setResult(Event.Result.DENY);
        } else {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!SomniaUtil.checkFatigue(player)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("somnia.status.cooldown"), true);
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
        } else if (!SomniaConfig.sleepWithArmor && !player.func_184812_l_() && SomniaUtil.doesPlayerWearArmor(player)) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent("somnia.status.armor"), true);
            event.setResult(PlayerEntity.SleepResult.OTHER_PROBLEM);
        }
        player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> props.setSleepNormally(player.func_225608_bj_()));
        if (Compat.isSleepingInBag(player)) {
            ASMHooks.updateWakeTime(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        event.getPlayer().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).map(IFatigue::resetSpawn).ifPresent(resetSpawn -> {
            if (!resetSpawn.booleanValue()) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            BlockPos pos = event.getPos();
            BlockState state = world.func_180495_p(pos);
            if (!state.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
                return;
            }
            Direction direction = (Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D);
            PlayerEntity player = event.getPlayer();
            if (!Compat.isBed(state, pos, (IBlockReader)world, (LivingEntity)player) || !((ServerPlayerEntity)player).func_241147_a_(pos, direction)) {
                return;
            }
            ItemStack stack = player.field_71071_by.func_70448_g();
            if (!stack.func_190926_b() && stack.func_77973_b().getRegistryName().toString().equals(SomniaConfig.wakeTimeSelectItem)) {
                NetworkHandler.sendToClient(new PacketOpenGUI(), (ServerPlayerEntity)player);
                event.setCancellationResult(ActionResultType.SUCCESS);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUseItem(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        Item item = stack.func_77973_b();
        if (stack.func_77975_n() == UseAction.DRINK) {
            Stream.of(SomniaConfig.replenishingItems, SomniaAPI.getReplenishingItems()).flatMap(Collection::stream).filter(pair -> ((Item)pair.getLeft()).getItem() == item).findFirst().ifPresent(pair -> event.getEntityLiving().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
                double fatigue = props.getFatigue();
                double replenishedFatigue = props.getReplenishedFatigue();
                double coffeeFatigueReplenish = (Double)pair.getMiddle();
                double fatigueToReplenish = Math.min(fatigue, coffeeFatigueReplenish);
                double newFatigue = replenishedFatigue + fatigueToReplenish;
                props.setReplenishedFatigue(newFatigue);
                double baseMultiplier = (Double)pair.getRight();
                double multiplier = newFatigue * 4.0 * SomniaConfig.fatigueRate;
                props.setExtraFatigueRate(props.getExtraFatigueRate() + baseMultiplier * multiplier);
                props.setFatigue(fatigue - fatigueToReplenish);
                props.maxFatigueCounter();
            }));
        }
    }

    @SubscribeEvent
    public static void worldLoadHook(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld worldServer = (ServerWorld)event.getWorld();
            ServerTickHandler.HANDLERS.add(new ServerTickHandler(worldServer));
            Somnia.LOGGER.info("Registering tick handler for loading world!");
        }
    }

    @SubscribeEvent
    public static void worldUnloadHook(WorldEvent.Unload event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld worldServer = (ServerWorld)event.getWorld();
            Iterator<ServerTickHandler> iter = ServerTickHandler.HANDLERS.iterator();
            while (iter.hasNext()) {
                ServerTickHandler serverTickHandler = iter.next();
                if (serverTickHandler.worldServer != worldServer) continue;
                Somnia.LOGGER.info("Removing tick handler for unloading world!");
                iter.remove();
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerDamage(LivingAttackEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && entity.func_70608_bn()) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            if (player.func_180431_b(event.getSource())) {
                return;
            }
            if (player.func_190530_aW() && !event.getSource().func_76357_e()) {
                return;
            }
            if (player.func_70027_ad() && player.func_70644_a(Effects.field_76426_n)) {
                return;
            }
            entity.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> props.setSleepOverride(false));
            entity.func_213366_dy();
            NetworkHandler.sendToClient(new PacketWakeUpPlayer(), (ServerPlayerEntity)entity);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        event.getEntityLiving().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
            props.setFatigue(0.0);
            props.setReplenishedFatigue(0.0);
            props.setExtraFatigueRate(0.0);
        });
    }
}

