/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.handler;

import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.api.capability.IFatigue;
import mods.su5ed.somnia.compat.Compat;
import mods.su5ed.somnia.compat.DarkUtilsPlugin;
import mods.su5ed.somnia.config.SomniaConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerSleepTickHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        event.player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
            if (event.phase == TickEvent.Phase.START) {
                PlayerSleepTickHandler.tickStart(props, event.player);
            } else {
                PlayerSleepTickHandler.tickEnd(props, event.player);
            }
        });
    }

    public static void tickStart(IFatigue props, PlayerEntity player) {
        if (player.func_70608_bn()) {
            if (props.shouldSleepNormally() || player.func_71060_bI() > 99 && ModList.get().isLoaded("darkutils") && DarkUtilsPlugin.hasSleepCharm(player) || Compat.isSleepingInHammock(player)) {
                props.setSleepOverride(false);
                return;
            }
            props.setSleepOverride(true);
            if (SomniaConfig.fading) {
                int sleepTimer = player.func_71060_bI() + 1;
                if (sleepTimer >= 99) {
                    sleepTimer = 98;
                }
                player.field_71076_b = sleepTimer;
            }
        }
    }

    public static void tickEnd(IFatigue props, PlayerEntity player) {
        if (props.sleepOverride()) {
            player.func_213342_e(player.func_213374_dv().orElse(player.func_233580_cy_()));
            props.setSleepOverride(false);
        }
    }
}

