/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.handler;

import com.mojang.brigadier.CommandDispatcher;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.api.capability.CapabilityFatigueProvider;
import mods.su5ed.somnia.core.SomniaCommand;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketUpdateFatigue;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        SomniaCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onEntityCapabilityAttach(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(CapabilityFatigue.NAME, (ICapabilityProvider)new CapabilityFatigueProvider());
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        RegistryHandler.sync((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        RegistryHandler.sync((ServerPlayerEntity)event.getPlayer());
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        RegistryHandler.sync((ServerPlayerEntity)event.getPlayer());
    }

    private static void sync(ServerPlayerEntity player) {
        player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> NetworkHandler.sendToClient(new PacketUpdateFatigue(props.getFatigue()), player));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntity().field_70170_p.field_72995_K) {
            event.getOriginal().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(props -> {
                CompoundNBT old = (CompoundNBT)props.serializeNBT();
                event.getPlayer().getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).ifPresent(fatigue -> fatigue.deserializeNBT((INBT)old));
            });
        }
    }
}

