/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import mods.su5ed.somnia.config.SomniaConfig;
import mods.su5ed.somnia.handler.ForgeEventHandler;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketUpdateSpeed;
import mods.su5ed.somnia.network.packet.PacketWakeUpPlayer;
import mods.su5ed.somnia.util.State;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SUpdateTimePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.hooks.BasicEventHooks;

public class ServerTickHandler {
    public static final List<ServerTickHandler> HANDLERS = new ArrayList<ServerTickHandler>();
    private static int tickHandlers = 0;
    public ServerWorld worldServer;
    public State currentState;
    private int timer = 0;
    private double overflow = 0.0;
    private double multiplier = SomniaConfig.baseMultiplier;

    public ServerTickHandler(ServerWorld worldServer) {
        this.worldServer = worldServer;
    }

    public void tickEnd() {
        if (++this.timer == 10) {
            this.timer = 0;
            State state = State.forWorld(this.worldServer);
            if (state != this.currentState) {
                if (this.currentState == State.SIMULATING) {
                    --tickHandlers;
                    if (state == State.UNAVAILABLE) {
                        this.closeGuiWithMessage(this.currentState.toString());
                    }
                } else if (state == State.SIMULATING) {
                    ++tickHandlers;
                }
            }
            if (state == State.SIMULATING || state == State.WAITING) {
                NetworkHandler.sendToDimension(new PacketUpdateSpeed(state == State.SIMULATING ? this.multiplier + this.overflow : 0.0), (RegistryKey<World>)this.worldServer.func_234923_W_());
            }
            this.currentState = state;
        }
        if (this.currentState == State.SIMULATING) {
            this.doMultipliedTicking();
        }
    }

    private void closeGuiWithMessage(@Nullable String key) {
        this.worldServer.func_217369_A().stream().filter(LivingEntity::func_70608_bn).forEach(player -> {
            NetworkHandler.sendToClient(new PacketWakeUpPlayer(), player);
            if (key != null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("somnia.status." + key), UUID.randomUUID());
            }
        });
    }

    private void doMultipliedTicking() {
        double target = this.multiplier + this.overflow;
        int flooredTarget = (int)target;
        this.overflow = target - (double)flooredTarget;
        long timeMillis = System.currentTimeMillis();
        for (int i = 0; i < flooredTarget; ++i) {
            this.doMultipliedServerTicking();
        }
        this.multiplier += (double)(System.currentTimeMillis() - timeMillis) <= SomniaConfig.delta / (double)tickHandlers ? 0.1 : -0.1;
        if (this.multiplier > SomniaConfig.multiplierCap) {
            this.multiplier = SomniaConfig.multiplierCap;
        }
        if (this.multiplier < SomniaConfig.baseMultiplier) {
            this.multiplier = SomniaConfig.baseMultiplier;
        }
    }

    private void doMultipliedServerTicking() {
        BasicEventHooks.onPreWorldTick((World)this.worldServer);
        this.worldServer.func_217369_A().stream().map(player -> new TickEvent.PlayerTickEvent(TickEvent.Phase.START, (PlayerEntity)player)).forEach(ForgeEventHandler::onPlayerTick);
        this.worldServer.func_72835_b(() -> ((MinecraftServer)this.worldServer.func_73046_m()).func_212379_aT());
        this.worldServer.func_73046_m().func_184103_al().func_232642_a_((IPacket)new SUpdateTimePacket(this.worldServer.func_82737_E(), this.worldServer.func_72820_D(), this.worldServer.func_82736_K().func_223586_b(GameRules.field_223607_j)), this.worldServer.func_234923_W_());
        BasicEventHooks.onPostWorldTick((World)this.worldServer);
    }
}

