/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.network.packet;

import com.google.common.base.MoreObjects;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketActivateBlock {
    private final BlockPos pos;
    private final Direction side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;

    public PacketActivateBlock(BlockPos pos, Direction side, float hitX, float hitY, float hitZ) {
        this.pos = pos;
        this.side = side;
        this.hitX = hitX;
        this.hitY = hitY;
        this.hitZ = hitZ;
    }

    public PacketActivateBlock(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.side = Direction.func_82600_a((int)buffer.readByte());
        this.hitX = buffer.readFloat();
        this.hitY = buffer.readFloat();
        this.hitZ = buffer.readFloat();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeByte(this.side.func_176745_a());
        buffer.writeFloat(this.hitX);
        buffer.writeFloat(this.hitY);
        buffer.writeFloat(this.hitZ);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                BlockState state = player.field_70170_p.func_180495_p(this.pos);
                BlockRayTraceResult rayTraceResult = new BlockRayTraceResult(new Vector3d((double)this.hitX, (double)this.hitY, (double)this.hitZ), this.side, this.pos, false);
                state.func_227031_a_(player.field_70170_p, (PlayerEntity)player, (Hand)MoreObjects.firstNonNull((Object)player.field_184622_au, (Object)Hand.MAIN_HAND), rayTraceResult);
            }
        });
        return true;
    }
}

