/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.config.SomniaConfig;
import mods.su5ed.somnia.handler.ServerTickHandler;
import mods.su5ed.somnia.network.NetworkHandler;
import mods.su5ed.somnia.network.packet.PacketUpdateWakeTime;
import mods.su5ed.somnia.util.SomniaUtil;
import mods.su5ed.somnia.util.State;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ASMHooks {
    public static boolean doMobSpawning(ServerWorld world) {
        boolean spawnMobs = world.func_82736_K().func_223586_b(GameRules.field_223601_d);
        if (!SomniaConfig.disableCreatureSpawning || !spawnMobs) {
            return spawnMobs;
        }
        return ServerTickHandler.HANDLERS.stream().filter(handler -> handler.worldServer == world).map(handler -> handler.currentState != State.SIMULATING).findAny().orElseThrow(() -> new IllegalStateException("Couldn't find tick handler for given world"));
    }

    public static void updateWakeTime(PlayerEntity player) {
        player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).filter(props -> props.getWakeTime() < 0L).ifPresent(props -> {
            long totalWorldTime;
            long wakeTime = SomniaUtil.calculateWakeTime(totalWorldTime, (totalWorldTime = player.field_70170_p.func_82737_E()) % 24000L > 12000L ? 0 : 12000);
            props.setWakeTime(wakeTime);
            NetworkHandler.sendToClient(new PacketUpdateWakeTime(wakeTime), (ServerPlayerEntity)player);
        });
    }

    public static boolean skipRenderWorld(float partialTicks, long finishTimeNano, MatrixStack stack) {
        return (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g.func_70608_bn() && SomniaConfig.disableRendering) {
                GlStateManager.func_227658_a_((int)16640, (boolean)false);
                return true;
            }
            return false;
        });
    }
}

