/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.util;

import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.config.SomniaConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.server.ServerWorld;

public class SomniaUtil {
    public static boolean doesPlayerWearArmor(PlayerEntity player) {
        return player.field_71071_by.field_70460_b.stream().anyMatch(stack -> !stack.func_190926_b());
    }

    public static long calculateWakeTime(long totalWorldTime, int target) {
        long timeInDay = totalWorldTime % 24000L;
        long wakeTime = totalWorldTime - timeInDay + (long)target;
        return timeInDay > (long)target ? wakeTime + 24000L : wakeTime;
    }

    public static boolean checkFatigue(PlayerEntity player) {
        return player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).map(props -> player.func_184812_l_() || props.getFatigue() >= SomniaConfig.minimumFatigueToSleep).orElse(false);
    }

    public static String timeStringForWorldTime(long time) {
        time += 6000L;
        String hours = String.valueOf((time %= 24000L) / 1000L);
        String minutes = String.valueOf((int)((double)(time % 1000L) / 1000.0 * 60.0));
        if (hours.length() == 1) {
            hours = "0" + hours;
        }
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        return hours + ":" + minutes;
    }

    public static double getFatigueToReplenish(PlayerEntity player) {
        long worldTime = player.field_70170_p.func_82737_E();
        long wakeTime = SomniaUtil.calculateWakeTime(worldTime, player.field_70170_p.func_226690_K_() ? 0 : 12000);
        return SomniaConfig.fatigueReplenishRate * (double)(wakeTime - worldTime);
    }

    public static boolean isEnterSleepTime() {
        return 24000 >= SomniaConfig.enterSleepStart && 24000 <= SomniaConfig.enterSleepEnd;
    }

    public static boolean isValidSleepTime(ServerWorld world) {
        long time = world.func_82737_E() % 24000L;
        return time >= (long)SomniaConfig.validSleepStart && time <= (long)SomniaConfig.validSleepEnd;
    }
}

