/*
 * Decompiled with CFR 0.152.
 */
package mods.su5ed.somnia.util;

import java.util.List;
import java.util.Optional;
import mods.su5ed.somnia.api.capability.CapabilityFatigue;
import mods.su5ed.somnia.api.capability.IFatigue;
import mods.su5ed.somnia.core.SomniaCommand;
import mods.su5ed.somnia.util.SomniaUtil;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.world.server.ServerWorld;

public enum State {
    INACTIVE,
    SIMULATING,
    WAITING,
    UNAVAILABLE;


    public static State forWorld(ServerWorld world) {
        if (!SomniaUtil.isValidSleepTime(world)) {
            return UNAVAILABLE;
        }
        List players = world.func_217369_A();
        if (!players.isEmpty()) {
            boolean anySleeping = false;
            boolean allSleeping = true;
            int somniaSleep = 0;
            int normalSleep = 0;
            for (ServerPlayerEntity player : players) {
                boolean sleeping = player.func_70608_bn() || SomniaCommand.OVERRIDES.contains(player.func_110124_au());
                anySleeping |= sleeping;
                allSleeping &= sleeping;
                Optional props = player.getCapability(CapabilityFatigue.FATIGUE_CAPABILITY).resolve();
                if (props.isPresent() && ((IFatigue)props.get()).shouldSleepNormally()) {
                    ++normalSleep;
                    continue;
                }
                ++somniaSleep;
            }
            if (allSleeping) {
                if (somniaSleep >= normalSleep) {
                    return SIMULATING;
                }
            } else if (anySleeping) {
                return WAITING;
            }
        }
        return INACTIVE;
    }
}

