/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft;

import com.cibernet.splatcraft.commands.CommandClearInk;
import com.cibernet.splatcraft.commands.CommandSetInkColor;
import com.cibernet.splatcraft.commands.CommandSplatCraftGamerules;
import com.cibernet.splatcraft.commands.CommandTurfWar;
import com.cibernet.splatcraft.proxy.CommonProxy;
import com.cibernet.splatcraft.scoreboard.CommandColorScores;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.utils.InkColors;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import net.minecraft.command.ICommand;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(name="Splatcraft", modid="splatcraft", version="2.2.2", acceptedMinecraftVersions="[1.12.2]")
public class SplatCraft {
    public static final String MODID = "splatcraft";
    public static final String NAME = "Splatcraft";
    public static final String VERSION = "2.2.2";
    public static final String SHORT = "SC";
    public static final int DEFAULT_INK = InkColors.INK_BLACK.getColor();
    public static Logger logger;
    public static boolean disableEyeHeight;
    @Mod.Instance(value="splatcraft")
    public static SplatCraft instance;
    @SidedProxy(clientSide="com.cibernet.splatcraft.proxy.ClientProxy", serverSide="com.cibernet.splatcraft.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        disableEyeHeight = Loader.isModLoaded((String)"moreplayermodels");
        logger = Logger.getLogger(MODID);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        File dataFile = event.getServer().func_71254_M().func_186352_b(event.getServer().func_71270_I(), "\\data\\SplatCraftData.dat");
        if (dataFile != null && dataFile.exists()) {
            NBTTagCompound nbt = null;
            try {
                nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dataFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nbt != null) {
                SplatcraftScoreboardHandler.readFromNBT(nbt);
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTurfWar());
        event.registerServerCommand((ICommand)new CommandClearInk());
        event.registerServerCommand((ICommand)new CommandSplatCraftGamerules());
        event.registerServerCommand((ICommand)new CommandSetInkColor());
        event.registerServerCommand((ICommand)new CommandColorScores());
    }
}

