/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarrierBar
extends BlockHorizontal {
    public static final PropertyEnum<BarShape> SHAPE = PropertyEnum.func_177709_a((String)"shape", BarShape.class);
    protected static final AxisAlignedBB STRAIGHT_AABB = new AxisAlignedBB(0.0, 0.8125, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EDGE_AABB = new AxisAlignedBB(0.0, 0.8125, 0.8125, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB ROTATED_STRAIGHT_AABB = BlockBarrierBar.modifyAABBForDirection(EnumFacing.EAST, STRAIGHT_AABB);
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);

    public BlockBarrierBar(String unlocName, String registryName) {
        super(Material.field_151573_f, MapColor.field_151660_b);
        this.func_149663_c(unlocName);
        this.setRegistryName(registryName);
        this.func_149711_c(3.0f);
        this.func_149647_a(TabSplatCraft.main);
        this.func_180632_j(this.func_176223_P().func_177226_a(SHAPE, (Comparable)((Object)BarShape.STRAIGHT)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE, field_185512_D});
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return side.ordinal() > 1;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (entityIn instanceof EntityPlayer && SplatCraftPlayerData.getIsSquid((EntityPlayer)entityIn) && SplatCraftUtils.canSquidClimb(worldIn, (EntityPlayer)entityIn)) {
            BlockBarrierBar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_AABB);
            return;
        }
        if (!isActualState) {
            state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        }
        for (AxisAlignedBB axisalignedbb : BlockBarrierBar.getCollisionBoxList(state)) {
            BlockBarrierBar.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        BarShape shape = (BarShape)((Object)state.func_177229_b(SHAPE));
        if (shape != BarShape.INNER_LEFT && shape != BarShape.INNER_RIGHT) {
            list.add(BlockBarrierBar.modifyAABBForDirection(facing, STRAIGHT_AABB));
        }
        switch (shape) {
            case INNER_LEFT: {
                list.add(BlockBarrierBar.modifyAABBForDirection(facing.func_176735_f(), EDGE_AABB));
                break;
            }
            case INNER_RIGHT: {
                list.add(BlockBarrierBar.modifyAABBForDirection(facing, EDGE_AABB));
                break;
            }
            case OUTER_LEFT: {
                list.add(BlockBarrierBar.modifyAABBForDirection(facing.func_176734_d(), ROTATED_STRAIGHT_AABB));
                break;
            }
            case OUTER_RIGHT: {
                list.add(BlockBarrierBar.modifyAABBForDirection(facing, ROTATED_STRAIGHT_AABB));
            }
        }
        return list;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        BarShape shape = (BarShape)((Object)this.func_176221_a(state, source, pos).func_177229_b(SHAPE));
        switch (shape) {
            case STRAIGHT: {
                return BlockBarrierBar.modifyAABBForDirection(facing, STRAIGHT_AABB);
            }
            case INNER_LEFT: {
                return BlockBarrierBar.modifyAABBForDirection(facing.func_176735_f(), EDGE_AABB);
            }
            case INNER_RIGHT: {
                return BlockBarrierBar.modifyAABBForDirection(facing, EDGE_AABB);
            }
            case OUTER_LEFT: {
                return TOP_AABB;
            }
            case OUTER_RIGHT: {
                return TOP_AABB;
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    public static AxisAlignedBB modifyAABBForDirection(EnumFacing facing, AxisAlignedBB bb) {
        switch (facing) {
            case EAST: {
                return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
            }
            case SOUTH: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
            case WEST: {
                return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
            }
        }
        return bb;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer);
        iblockstate = iblockstate.func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a(SHAPE, (Comparable)((Object)BarShape.STRAIGHT));
        return iblockstate;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.func_82600_a((int)(5 - (meta & 3))));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= 5 - ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(SHAPE, (Comparable)((Object)BlockBarrierBar.getStairsShape(state, worldIn, pos)));
    }

    private static BarShape getStairsShape(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_185512_D);
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(enumfacing));
        if (BlockBarrierBar.isBlockStairs(iblockstate) && (enumfacing1 = (EnumFacing)iblockstate.func_177229_b((IProperty)field_185512_D)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() && BlockBarrierBar.isDifferentStairs(state, world, pos, enumfacing1.func_176734_d())) {
            if (enumfacing1 == enumfacing.func_176735_f()) {
                return BarShape.OUTER_LEFT;
            }
            return BarShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = world.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d()));
        if (BlockBarrierBar.isBlockStairs(iblockstate1) && (enumfacing2 = (EnumFacing)iblockstate1.func_177229_b((IProperty)field_185512_D)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k() && BlockBarrierBar.isDifferentStairs(state, world, pos, enumfacing2)) {
            if (enumfacing2 == enumfacing.func_176735_f()) {
                return BarShape.INNER_LEFT;
            }
            return BarShape.INNER_RIGHT;
        }
        return BarShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(facing));
        return !BlockBarrierBar.isBlockStairs(iblockstate) || iblockstate.func_177229_b((IProperty)field_185512_D) != state.func_177229_b((IProperty)field_185512_D);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockBarrierBar;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum BarShape implements IStringSerializable
    {
        STRAIGHT("straight"),
        INNER_LEFT("inner_left"),
        INNER_RIGHT("inner_right"),
        OUTER_LEFT("outer_left"),
        OUTER_RIGHT("outer_right");

        private final String name;

        private BarShape(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

