/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkedBlock;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.TabSplatCraft;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCanvas
extends BlockInkColor {
    public static final PropertyBool INKED = PropertyBool.func_177716_a((String)"inked");

    public BlockCanvas() {
        super(Material.field_151580_n);
        this.func_149663_c("canvas");
        this.setRegistryName("canvas");
        this.func_149647_a(TabSplatCraft.main);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)INKED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{INKED});
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)INKED) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)INKED, (Comparable)Boolean.valueOf(meta == 1));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean isInked = false;
        if (worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            isInked = ((TileEntityColor)worldIn.func_175625_s(pos)).getColor() != -1;
        }
        return this.func_176223_P().func_177226_a((IProperty)INKED, (Comparable)Boolean.valueOf(isInked));
    }

    @Override
    public int getDefaultColor() {
        return -1;
    }

    @Override
    protected boolean tryTouchWater(World worldIn, BlockPos pos, IBlockState state) {
        boolean touchingWater = false;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            BlockPos blockpos;
            if (enumfacing == EnumFacing.DOWN || worldIn.func_180495_p(blockpos = pos.func_177972_a(enumfacing)).func_185904_a() != Material.field_151586_h) continue;
            touchingWater = true;
            break;
        }
        if (touchingWater && worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            TileEntityColor te = (TileEntityColor)worldIn.func_175625_s(pos);
            te.setColor(this.getDefaultColor());
            worldIn.func_184138_a(pos, state, state, 3);
        }
        return touchingWater;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (worldIn.func_180495_p(fromPos).func_185904_a().equals(Material.field_151586_h) && worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            TileEntityColor te = (TileEntityColor)worldIn.func_175625_s(pos);
            te.setColor(this.getDefaultColor());
            worldIn.func_184138_a(pos, state, state, 3);
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.tryTouchWater(worldIn, pos, state)) {
            super.func_176213_c(worldIn, pos, state);
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof TileEntityInkedBlock)) {
            return super.func_180659_g(state, worldIn, pos);
        }
        TileEntityInkedBlock te = (TileEntityInkedBlock)worldIn.func_175625_s(pos);
        InkColors color = InkColors.getByColor(te.getColor());
        if (color == null) {
            return super.func_180659_g(state, worldIn, pos);
        }
        return color.getMapColor();
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        if (player.func_184614_ca().func_77973_b() instanceof ItemShears) {
            return 0.95f;
        }
        return super.func_180647_a(state, player, worldIn, pos);
    }

    @Override
    public boolean canSwim() {
        return true;
    }
}

