/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.SplatCraft;
import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.utils.ColorItemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInkColor
extends Block
implements IInked {
    public static List<Block> blocks = new ArrayList<Block>();
    public boolean canInk = true;
    public boolean dropColored = false;

    public BlockInkColor(Material materialIn) {
        super(materialIn);
        blocks.add(this);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityColor(this.getDefaultColor());
    }

    private static NBTTagCompound checkTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    public static ItemStack setInkColor(ItemStack stack, int color) {
        BlockInkColor.checkTagCompound(stack).func_74768_a("color", color);
        return stack;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList oldDrops = NonNullList.func_191196_a();
        super.getDrops(oldDrops, world, pos, state, fortune);
        int color = SplatCraft.DEFAULT_INK;
        if (world.func_175625_s(pos) instanceof TileEntityColor) {
            color = ((TileEntityColor)world.func_175625_s(pos)).getColor();
        }
        if (this.dropColored) {
            for (ItemStack stack : oldDrops) {
                drops.add((Object)ColorItemUtils.setInkColor(stack, color));
            }
        } else {
            drops.addAll((Collection)oldDrops);
        }
    }

    @Override
    public boolean canInk() {
        return this.canInk;
    }

    @Override
    public boolean canDamage() {
        return false;
    }

    @Override
    public boolean canSwim() {
        return false;
    }

    @Override
    public boolean countsTowardsScore() {
        return false;
    }
}

